/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui;

import com.jediterm.core.Color;
import com.jediterm.core.TerminalCoordinates;
import com.jediterm.core.compatibility.Point;
import com.jediterm.core.typeahead.TerminalTypeAheadManager;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.CursorShape;
import com.jediterm.terminal.DefaultTerminalCopyPasteHandler;
import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TerminalCopyPasteHandler;
import com.jediterm.terminal.TerminalDisplay;
import com.jediterm.terminal.TerminalOutputStream;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.emulator.ColorPalette;
import com.jediterm.terminal.emulator.charset.CharacterSets;
import com.jediterm.terminal.emulator.mouse.MouseFormat;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import com.jediterm.terminal.emulator.mouse.TerminalMouseListener;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.model.LinesStorage;
import com.jediterm.terminal.model.SelectionUtil;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalLineIntervalHighlighting;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.model.TerminalSelectionChangesListener;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.model.hyperlinks.LinkInfo;
import com.jediterm.terminal.model.hyperlinks.TextProcessing;
import com.jediterm.terminal.ui.AwtTransformers;
import com.jediterm.terminal.ui.BlinkingTextTracker;
import com.jediterm.terminal.ui.Cell;
import com.jediterm.terminal.ui.LineCellInterval;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionProvider;
import com.jediterm.terminal.ui.UtilKt;
import com.jediterm.terminal.ui.hyperlinks.LinkInfoEx;
import com.jediterm.terminal.ui.input.AwtMouseEvent;
import com.jediterm.terminal.ui.input.AwtMouseWheelEvent;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.jediterm.terminal.util.CharUtils;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.text.AttributedCharacterIterator;
import java.text.BreakIterator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalPanel
extends JComponent
implements TerminalDisplay,
TerminalActionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TerminalPanel.class);
    private static final long serialVersionUID = -1048763516632093014L;
    public static final double SCROLL_SPEED = 0.05;
    private Font myNormalFont;
    private Font myItalicFont;
    private Font myBoldFont;
    private Font myBoldItalicFont;
    private int myDescent = 0;
    private int mySpaceBetweenLines = 0;
    protected final Dimension myCharSize = new Dimension();
    private boolean myMonospaced;
    private TermSize myTermSize;
    private boolean myInitialSizeSyncDone = false;
    private TerminalStarter myTerminalStarter = null;
    private MouseMode myMouseMode = MouseMode.MOUSE_REPORTING_NONE;
    private Point mySelectionStartPoint = null;
    private TerminalSelection mySelection = null;
    private final TerminalCopyPasteHandler myCopyPasteHandler;
    private final SettingsProvider mySettingsProvider;
    private final TerminalTextBuffer myTerminalTextBuffer;
    private final StyleState myStyleState;
    private final TerminalCursor myCursor = new TerminalCursor();
    private final BlinkingTextTracker myTextBlinkingTracker = new BlinkingTextTracker();
    private final BoundedRangeModel myBoundedRangeModel = new DefaultBoundedRangeModel(0, 80, 0, 80);
    private boolean myScrollingEnabled = true;
    protected int myClientScrollOrigin;
    private final List<KeyListener> myCustomKeyListeners = new CopyOnWriteArrayList<KeyListener>();
    private final List<TerminalSelectionChangesListener> selectionChangesListeners = new CopyOnWriteArrayList<TerminalSelectionChangesListener>();
    private String myWindowTitle = "Terminal";
    private TerminalActionProvider myNextActionProvider;
    private String myInputMethodUncommittedChars;
    private Timer myRepaintTimer;
    private final AtomicInteger scrollDy = new AtomicInteger(0);
    private final AtomicBoolean myHistoryBufferLineCountChanged = new AtomicBoolean(false);
    private final AtomicBoolean needRepaint = new AtomicBoolean(true);
    private int myMaxFPS = 50;
    private int myBlinkingPeriod = 500;
    private TerminalCoordinates myCoordsAccessor;
    private SubstringFinder.FindResult myFindResult;
    private LinkInfo myHoveredHyperlink = null;
    private int myCursorType = 0;
    private final TerminalKeyHandler myTerminalKeyHandler = new TerminalKeyHandler();
    private LinkInfoEx.HoverConsumer myLinkHoverConsumer;
    private TerminalTypeAheadManager myTypeAheadManager;
    private volatile boolean myBracketedPasteMode;
    private boolean myUsingAlternateBuffer = false;
    private boolean myFillCharacterBackgroundIncludingLineSpacing;
    @Nullable
    private TextStyle myCachedSelectionColor;
    @Nullable
    private TextStyle myCachedFoundPatternColor;
    private static final byte ASCII_NUL = 0;
    private static final byte ASCII_ESC = 27;

    public TerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull TerminalTextBuffer terminalTextBuffer, @NotNull StyleState styleState) {
        this.mySettingsProvider = settingsProvider;
        this.myTerminalTextBuffer = terminalTextBuffer;
        this.myStyleState = styleState;
        this.myTermSize = new TermSize(terminalTextBuffer.getWidth(), terminalTextBuffer.getHeight());
        this.myMaxFPS = this.mySettingsProvider.maxRefreshRate();
        this.myCopyPasteHandler = this.createCopyPasteHandler();
        this.updateScrolling(true);
        this.enableEvents(2056L);
        this.enableInputMethods(true);
        terminalTextBuffer.addModelListener(this::repaint);
        terminalTextBuffer.addHistoryBufferListener(() -> this.myHistoryBufferLineCountChanged.set(true));
        TextProcessing textProcessing = terminalTextBuffer.getTextProcessing$core();
        if (textProcessing != null) {
            textProcessing.addHyperlinkListener(this::repaint);
        }
    }

    void setTypeAheadManager(@NotNull TerminalTypeAheadManager typeAheadManager) {
        this.myTypeAheadManager = typeAheadManager;
    }

    @NotNull
    protected TerminalCopyPasteHandler createCopyPasteHandler() {
        return new DefaultTerminalCopyPasteHandler();
    }

    @Override
    public void repaint() {
        this.needRepaint.set(true);
    }

    private void doRepaint() {
        super.repaint();
    }

    protected void reinitFontAndResize() {
        this.initFont();
        this.sizeTerminalFromComponent();
    }

    protected void initFont() {
        this.myNormalFont = this.createFont();
        this.myBoldFont = this.myNormalFont.deriveFont(1);
        this.myItalicFont = this.myNormalFont.deriveFont(2);
        this.myBoldItalicFont = this.myNormalFont.deriveFont(3);
        this.establishFontMetrics();
    }

    public void init(@NotNull JScrollBar scrollBar) {
        this.initFont();
        this.setPreferredSize(new Dimension(this.getPixelWidth(), this.getPixelHeight()));
        this.setFocusable(true);
        this.enableInputMethods(true);
        this.setDoubleBuffered(true);
        this.setFocusTraversalKeysEnabled(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                TerminalPanel.this.handleHyperlinks(e.getPoint());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!TerminalPanel.this.isLocalMouseAction(e)) {
                    return;
                }
                Point charCoords = TerminalPanel.this.panelToCharCoords(e.getPoint());
                if (TerminalPanel.this.mySelection == null) {
                    if (TerminalPanel.this.mySelectionStartPoint == null) {
                        TerminalPanel.this.mySelectionStartPoint = charCoords;
                    }
                    TerminalPanel.this.updateSelection(new TerminalSelection(new Point(TerminalPanel.this.mySelectionStartPoint)));
                }
                TerminalPanel.this.repaint();
                TerminalPanel.this.updateSelectionEnd(charCoords);
                if (TerminalPanel.this.mySettingsProvider.copyOnSelect()) {
                    TerminalPanel.this.handleCopyOnSelect();
                }
                if (e.getPoint().y < 0) {
                    TerminalPanel.this.moveScrollBar((int)((double)e.getPoint().y * 0.05));
                }
                if (e.getPoint().y > TerminalPanel.this.getPixelHeight()) {
                    TerminalPanel.this.moveScrollBar((int)((double)(e.getPoint().y - TerminalPanel.this.getPixelHeight()) * 0.05));
                }
            }
        });
        this.addMouseWheelListener(e -> {
            if (this.isLocalMouseAction(e)) {
                this.handleMouseWheelEvent(e, scrollBar);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (TerminalPanel.this.myLinkHoverConsumer != null) {
                    TerminalPanel.this.myLinkHoverConsumer.onMouseExited();
                    TerminalPanel.this.myLinkHoverConsumer = null;
                }
                TerminalPanel.this.updateHoveredHyperlink(null);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 1) {
                    TerminalPanel.this.mySelectionStartPoint = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    TerminalPanel.this.updateSelection(null);
                    TerminalPanel.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TerminalPanel.this.requestFocusInWindow();
                TerminalPanel.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                HyperlinkStyle hyperlink;
                TerminalPanel.this.requestFocusInWindow();
                HyperlinkStyle hyperlinkStyle = hyperlink = TerminalPanel.this.isFollowLinkEvent(e) ? TerminalPanel.this.findHyperlink(e.getPoint()) : null;
                if (hyperlink != null) {
                    hyperlink.getLinkInfo().navigate();
                } else if (e.getButton() == 1 && TerminalPanel.this.isLocalMouseAction(e)) {
                    int count = e.getClickCount();
                    if (count != 1) {
                        if (count == 2) {
                            Point charCoords = TerminalPanel.this.panelToCharCoords(e.getPoint());
                            Point start = SelectionUtil.getPreviousSeparator(charCoords, TerminalPanel.this.myTerminalTextBuffer);
                            Point stop = SelectionUtil.getNextSeparator(charCoords, TerminalPanel.this.myTerminalTextBuffer);
                            TerminalPanel.this.updateSelection(new TerminalSelection(start));
                            TerminalPanel.this.updateSelectionEnd(stop);
                            if (TerminalPanel.this.mySettingsProvider.copyOnSelect()) {
                                TerminalPanel.this.handleCopyOnSelect();
                            }
                        } else if (count == 3) {
                            int endLine;
                            int startLine;
                            Point charCoords = TerminalPanel.this.panelToCharCoords(e.getPoint());
                            for (startLine = charCoords.y; startLine > -TerminalPanel.this.getScrollLinesStorage().getSize() && TerminalPanel.this.myTerminalTextBuffer.getLine(startLine - 1).isWrapped(); --startLine) {
                            }
                            for (endLine = charCoords.y; endLine < TerminalPanel.this.myTerminalTextBuffer.getHeight() && TerminalPanel.this.myTerminalTextBuffer.getLine(endLine).isWrapped(); ++endLine) {
                            }
                            TerminalPanel.this.updateSelection(new TerminalSelection(new Point(0, startLine)));
                            TerminalPanel.this.updateSelectionEnd(new Point(TerminalPanel.this.myTermSize.getColumns(), endLine));
                            if (TerminalPanel.this.mySettingsProvider.copyOnSelect()) {
                                TerminalPanel.this.handleCopyOnSelect();
                            }
                        }
                    }
                } else if (e.getButton() == 2 && TerminalPanel.this.mySettingsProvider.pasteOnMiddleMouseClick() && TerminalPanel.this.isLocalMouseAction(e)) {
                    TerminalPanel.this.handlePasteSelection();
                } else if (e.getButton() == 3) {
                    HyperlinkStyle contextHyperlink = TerminalPanel.this.findHyperlink(e.getPoint());
                    TerminalActionProvider provider = TerminalPanel.this.getTerminalActionProvider(contextHyperlink != null ? contextHyperlink.getLinkInfo() : null, e);
                    JPopupMenu popup = TerminalPanel.this.createPopupMenu(provider);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
                TerminalPanel.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TerminalPanel.this.sizeTerminalFromComponent();
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && TerminalPanel.this.isShowing()) {
                    SwingUtilities.invokeLater(() -> TerminalPanel.this.sizeTerminalFromComponent());
                    TerminalPanel.this.removeHierarchyListener(this);
                }
            }
        });
        this.myFillCharacterBackgroundIncludingLineSpacing = this.mySettingsProvider.shouldFillCharacterBackgroundIncludingLineSpacing();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TerminalPanel.this.myFillCharacterBackgroundIncludingLineSpacing = TerminalPanel.this.mySettingsProvider.shouldFillCharacterBackgroundIncludingLineSpacing();
                TerminalPanel.this.myCursor.cursorChanged();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TerminalPanel.this.myCursor.cursorChanged();
                TerminalPanel.this.handleHyperlinks(e.getComponent());
            }
        });
        this.myBoundedRangeModel.addChangeListener(e -> {
            this.myClientScrollOrigin = this.myBoundedRangeModel.getValue();
            this.repaint();
        });
        this.createRepaintTimer();
    }

    private boolean isFollowLinkEvent(@NotNull MouseEvent e) {
        return this.myCursorType == 12 && e.getButton() == 1;
    }

    protected void handleMouseWheelEvent(@NotNull MouseWheelEvent e, @NotNull JScrollBar scrollBar) {
        if (e.isShiftDown() || e.getUnitsToScroll() == 0 || Math.abs(e.getPreciseWheelRotation()) < 0.01) {
            return;
        }
        this.moveScrollBar(e.getUnitsToScroll());
        e.consume();
    }

    private void handleHyperlinks(@NotNull java.awt.Point panelPoint) {
        Cell cell = this.panelPointToCell(panelPoint);
        HyperlinkStyle linkStyle = this.findHyperlink(cell);
        LinkInfo linkInfo = linkStyle != null ? linkStyle.getLinkInfo() : null;
        LinkInfoEx.HoverConsumer linkHoverConsumer = LinkInfoEx.getHoverConsumer(linkInfo);
        if (linkHoverConsumer != this.myLinkHoverConsumer) {
            if (this.myLinkHoverConsumer != null) {
                this.myLinkHoverConsumer.onMouseExited();
            }
            if (linkHoverConsumer != null) {
                LineCellInterval lineCellInterval = this.findIntervalWithStyle(cell, linkStyle);
                linkHoverConsumer.onMouseEntered(this, this.getBounds(lineCellInterval));
            }
        }
        this.myLinkHoverConsumer = linkHoverConsumer;
        if (linkStyle != null && linkStyle.getHighlightMode() != HyperlinkStyle.HighlightMode.NEVER) {
            this.updateHoveredHyperlink(linkStyle.getLinkInfo());
        } else {
            this.updateHoveredHyperlink(null);
        }
    }

    private void updateHoveredHyperlink(@Nullable LinkInfo hoveredHyperlink) {
        if (this.myHoveredHyperlink != hoveredHyperlink) {
            this.updateCursor(hoveredHyperlink != null ? 12 : 0);
            this.myHoveredHyperlink = hoveredHyperlink;
            this.repaint();
        }
    }

    @NotNull
    private LineCellInterval findIntervalWithStyle(@NotNull Cell initialCell, @NotNull HyperlinkStyle style) {
        int endColumn;
        int startColumn;
        for (startColumn = initialCell.getColumn(); startColumn > 0 && style == this.myTerminalTextBuffer.getStyleAt(startColumn - 1, initialCell.getLine()); --startColumn) {
        }
        for (endColumn = initialCell.getColumn(); endColumn < this.myTerminalTextBuffer.getWidth() - 1 && style == this.myTerminalTextBuffer.getStyleAt(endColumn + 1, initialCell.getLine()); ++endColumn) {
        }
        return new LineCellInterval(initialCell.getLine(), startColumn, endColumn);
    }

    private void handleHyperlinks(Component component) {
        PointerInfo a = MouseInfo.getPointerInfo();
        if (a != null) {
            java.awt.Point b = a.getLocation();
            SwingUtilities.convertPointFromScreen(b, component);
            this.handleHyperlinks(b);
        }
    }

    @Nullable
    private HyperlinkStyle findHyperlink(@NotNull java.awt.Point p) {
        return this.findHyperlink(this.panelPointToCell(p));
    }

    @Nullable
    private HyperlinkStyle findHyperlink(@Nullable Cell cell) {
        TextStyle style;
        if (cell != null && cell.getColumn() >= 0 && cell.getColumn() < this.myTerminalTextBuffer.getWidth() && cell.getLine() >= -this.myTerminalTextBuffer.getHistoryLinesCount() && cell.getLine() <= this.myTerminalTextBuffer.getHeight() && (style = this.myTerminalTextBuffer.getStyleAt(cell.getColumn(), cell.getLine())) instanceof HyperlinkStyle) {
            return (HyperlinkStyle)style;
        }
        return null;
    }

    private void updateCursor(int cursorType) {
        if (cursorType != this.myCursorType) {
            this.myCursorType = cursorType;
            this.setCursor(new Cursor(this.myCursorType));
        }
    }

    private void createRepaintTimer() {
        if (this.myRepaintTimer != null) {
            this.myRepaintTimer.stop();
        }
        this.myRepaintTimer = new Timer(1000 / this.myMaxFPS, new WeakRedrawTimer(this));
        this.myRepaintTimer.start();
    }

    public boolean isLocalMouseAction(MouseEvent e) {
        return this.mySettingsProvider.forceActionOnMouseReporting() || this.isMouseReporting() == e.isShiftDown();
    }

    public boolean isRemoteMouseAction(MouseEvent e) {
        return this.isMouseReporting() && !e.isShiftDown();
    }

    public void setBlinkingPeriod(int blinkingPeriod) {
        this.myBlinkingPeriod = blinkingPeriod;
    }

    public void setCoordAccessor(TerminalCoordinates coordAccessor) {
        this.myCoordsAccessor = coordAccessor;
    }

    public void setFindResult(@Nullable SubstringFinder.FindResult findResult) {
        this.myFindResult = findResult;
        this.repaint();
    }

    public SubstringFinder.FindResult getFindResult() {
        return this.myFindResult;
    }

    @Nullable
    public SubstringFinder.FindResult selectPrevFindResultItem() {
        return this.selectPrevOrNextFindResultItem(false);
    }

    @Nullable
    public SubstringFinder.FindResult selectNextFindResultItem() {
        return this.selectPrevOrNextFindResultItem(true);
    }

    @Nullable
    protected SubstringFinder.FindResult selectPrevOrNextFindResultItem(boolean next) {
        if (this.myFindResult != null && !this.myFindResult.getItems().isEmpty()) {
            SubstringFinder.FindResult.FindItem item = next ? this.myFindResult.nextFindItem() : this.myFindResult.prevFindItem();
            this.updateSelection(new TerminalSelection(new Point(item.getStart().x, item.getStart().y - this.myTerminalTextBuffer.getHistoryLinesCount()), new Point(item.getEnd().x, item.getEnd().y - this.myTerminalTextBuffer.getHistoryLinesCount())));
            if (this.mySelection.getStart().y < this.getTerminalTextBuffer().getHeight() / 2) {
                this.myBoundedRangeModel.setValue(this.mySelection.getStart().y - this.getTerminalTextBuffer().getHeight() / 2);
            } else {
                this.myBoundedRangeModel.setValue(0);
            }
            this.repaint();
            return this.myFindResult;
        }
        return null;
    }

    @Override
    public void terminalMouseModeSet(@NotNull MouseMode mouseMode) {
        this.myMouseMode = mouseMode;
    }

    @Override
    public void setMouseFormat(@NotNull MouseFormat mouseFormat) {
    }

    private boolean isMouseReporting() {
        return this.myMouseMode != MouseMode.MOUSE_REPORTING_NONE;
    }

    private void scrollToBottom() {
        int zeroBasedCursorY = this.myCursor.myCursorCoordinates.y - 1;
        int delta = 1;
        if (zeroBasedCursorY + delta >= this.myBoundedRangeModel.getValue() + this.myBoundedRangeModel.getExtent()) {
            this.myBoundedRangeModel.setValue(0);
        }
    }

    private void pageUp() {
        this.moveScrollBar(-this.myTermSize.getRows());
    }

    private void pageDown() {
        this.moveScrollBar(this.myTermSize.getRows());
    }

    private void scrollUp() {
        this.moveScrollBar(-1);
    }

    private void scrollDown() {
        this.moveScrollBar(1);
    }

    private void moveScrollBar(int k) {
        this.myBoundedRangeModel.setValue(this.myBoundedRangeModel.getValue() + k);
    }

    protected Font createFont() {
        return this.mySettingsProvider.getTerminalFont();
    }

    @NotNull
    private Point panelToCharCoords(java.awt.Point p) {
        Cell cell = this.panelPointToCell(p);
        return new Point(cell.getColumn(), cell.getLine());
    }

    @NotNull
    private Cell panelPointToCell(@NotNull java.awt.Point p) {
        int x = Math.min((p.x - this.getInsetX()) / this.myCharSize.width, this.getColumnCount() - 1);
        x = Math.max(0, x);
        int y = Math.min(p.y / this.myCharSize.height, this.getRowCount() - 1) + this.myClientScrollOrigin;
        return new Cell(y, x);
    }

    private void copySelection(@Nullable Point selectionStart, @Nullable Point selectionEnd, boolean useSystemSelectionClipboardIfAvailable) {
        if (selectionStart == null || selectionEnd == null) {
            return;
        }
        String selectionText = SelectionUtil.getSelectionText(selectionStart, selectionEnd, this.myTerminalTextBuffer);
        if (selectionText.length() != 0) {
            this.myCopyPasteHandler.setContents(selectionText, useSystemSelectionClipboardIfAvailable);
        }
    }

    private void pasteFromClipboard(boolean useSystemSelectionClipboardIfAvailable) {
        Object text = this.myCopyPasteHandler.getContents(useSystemSelectionClipboardIfAvailable);
        if (text == null) {
            return;
        }
        try {
            if (!UtilKt.isWindows()) {
                text = ((String)text).replace("\r\n", "\n");
            }
            text = ((String)text).replace('\n', '\r');
            if (this.myBracketedPasteMode) {
                text = "\u001b[200~" + (String)text + "\u001b[201~";
            }
            this.myTerminalStarter.sendString((String)text, true);
        }
        catch (RuntimeException e) {
            LOG.info("", e);
        }
    }

    @Nullable
    private String getClipboardString() {
        return this.myCopyPasteHandler.getContents(false);
    }

    protected void drawImage(Graphics2D gfx, BufferedImage image, int x, int y, ImageObserver observer) {
        gfx.drawImage(image, x, y, image.getWidth(), image.getHeight(), observer);
    }

    protected BufferedImage createBufferedImage(int width, int height) {
        return new BufferedImage(width, height, 1);
    }

    @Nullable
    public TermSize getTerminalSizeFromComponent() {
        int columns = (this.getWidth() - this.getInsetX()) / this.myCharSize.width;
        int rows = this.getHeight() / this.myCharSize.height;
        return rows > 0 && columns > 0 ? new TermSize(columns, rows) : null;
    }

    private void sizeTerminalFromComponent() {
        TermSize newSize;
        if (!(this.myTerminalStarter == null || (newSize = this.getTerminalSizeFromComponent()) == null || this.myTermSize.equals(newSize = JediTerminal.ensureTermMinimumSize(newSize)) && this.myInitialSizeSyncDone)) {
            this.myTermSize = newSize;
            this.myInitialSizeSyncDone = true;
            this.myTypeAheadManager.onResize();
            this.myTerminalStarter.postResize(newSize, RequestOrigin.User);
        }
    }

    public void setTerminalStarter(TerminalStarter terminalStarter) {
        this.myTerminalStarter = terminalStarter;
        this.sizeTerminalFromComponent();
    }

    public void addCustomKeyListener(@NotNull KeyListener keyListener) {
        this.myCustomKeyListeners.add(keyListener);
    }

    public void removeCustomKeyListener(@NotNull KeyListener keyListener) {
        this.myCustomKeyListeners.remove(keyListener);
    }

    public void addSelectionListener(@NotNull TerminalSelectionChangesListener selectionListener) {
        this.selectionChangesListeners.add(selectionListener);
    }

    public void removeSelectionListener(@NotNull TerminalSelectionChangesListener selectionListener) {
        this.selectionChangesListeners.remove(selectionListener);
    }

    @Override
    public void onResize(@NotNull TermSize newTermSize, @NotNull RequestOrigin origin) {
        this.myTermSize = newTermSize;
        this.setPreferredSize(new Dimension(this.getPixelWidth(), this.getPixelHeight()));
        SwingUtilities.invokeLater(() -> this.updateScrolling(true));
    }

    private void establishFontMetrics() {
        BufferedImage img = this.createBufferedImage(1, 1);
        Graphics2D graphics = img.createGraphics();
        graphics.setFont(this.myNormalFont);
        float lineSpacing = this.getLineSpacing();
        FontMetrics fo = graphics.getFontMetrics();
        this.myCharSize.width = fo.charWidth('W');
        int fontMetricsHeight = fo.getHeight();
        this.myCharSize.height = (int)Math.ceil((float)fontMetricsHeight * lineSpacing);
        this.mySpaceBetweenLines = Math.max(0, (this.myCharSize.height - fontMetricsHeight) / 2 * 2);
        this.myDescent = fo.getDescent();
        if (LOG.isDebugEnabled()) {
            int oldCharHeight = fontMetricsHeight + (int)(lineSpacing * 2.0f) + 2;
            int oldDescent = fo.getDescent() + (int)lineSpacing;
            LOG.debug("charHeight=" + oldCharHeight + "->" + this.myCharSize.height + ", descent=" + oldDescent + "->" + this.myDescent);
        }
        this.myMonospaced = TerminalPanel.isMonospaced(fo);
        if (!this.myMonospaced) {
            LOG.info("WARNING: Font " + this.myNormalFont.getName() + " is non-monospaced");
        }
        img.flush();
        graphics.dispose();
    }

    private float getLineSpacing() {
        if (this.myTerminalTextBuffer.isUsingAlternateBuffer() && this.mySettingsProvider.shouldDisableLineSpacingForAlternateScreenBuffer()) {
            return 1.0f;
        }
        return this.mySettingsProvider.getLineSpacing();
    }

    private static boolean isMonospaced(FontMetrics fontMetrics) {
        boolean isMonospaced = true;
        int charWidth = -1;
        for (int codePoint = 0; codePoint < 128; ++codePoint) {
            char character;
            if (!Character.isValidCodePoint(codePoint) || !TerminalPanel.isWordCharacter(character = (char)codePoint)) continue;
            int w = fontMetrics.charWidth(character);
            if (charWidth != -1) {
                if (w == charWidth) continue;
                isMonospaced = false;
                break;
            }
            charWidth = w;
        }
        return isMonospaced;
    }

    private static boolean isWordCharacter(char character) {
        return Character.isLetterOrDigit(character);
    }

    protected void setupAntialiasing(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            Graphics2D myGfx = (Graphics2D)graphics;
            Object mode = this.mySettingsProvider.useAntialiasing() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, mode);
            myGfx.setRenderingHints(hints);
        }
    }

    @Override
    @NotNull
    public java.awt.Color getBackground() {
        return AwtTransformers.toAwtColor(this.getWindowBackground());
    }

    @Override
    @NotNull
    public java.awt.Color getForeground() {
        return AwtTransformers.toAwtColor(this.getWindowForeground());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        this.resetColorCache();
        final Graphics2D gfx = (Graphics2D)g;
        this.setupAntialiasing(gfx);
        gfx.setColor(this.getBackground());
        gfx.fillRect(0, 0, this.getWidth(), this.getHeight());
        try {
            this.myTerminalTextBuffer.lock();
            this.updateScrolling(false);
            this.myTerminalTextBuffer.processHistoryAndScreenLines(this.myClientScrollOrigin, this.myTermSize.getRows(), new StyledTextConsumer(){
                final int columnCount;
                {
                    this.columnCount = TerminalPanel.this.getColumnCount();
                }

                @Override
                public void consume(int x, int y, @NotNull TextStyle style, @NotNull CharBuffer characters, int startRow) {
                    Pair<Integer, Integer> interval;
                    List<Pair<Integer, Integer>> ranges;
                    int row = y - startRow;
                    TerminalPanel.this.drawCharacters(x, row, style, characters, gfx, TerminalPanel.this.myFillCharacterBackgroundIncludingLineSpacing);
                    if (TerminalPanel.this.myFindResult != null && (ranges = TerminalPanel.this.myFindResult.getRanges(characters)) != null && !ranges.isEmpty()) {
                        TextStyle foundPatternStyle = TerminalPanel.this.getFoundPattern(style);
                        for (Pair<Integer, Integer> range : ranges) {
                            CharBuffer foundPatternChars = characters.subBuffer(range);
                            TerminalPanel.this.drawCharacters(x + range.getFirst(), row, foundPatternStyle, foundPatternChars, gfx);
                        }
                    }
                    if (TerminalPanel.this.mySelection != null && (interval = TerminalPanel.this.mySelection.intersect(x, row + TerminalPanel.this.myClientScrollOrigin, characters.length())) != null) {
                        TextStyle selectionStyle = TerminalPanel.this.getSelectionStyle(style);
                        CharBuffer selectionChars = characters.subBuffer(interval.getFirst() - x, interval.getSecond());
                        TerminalPanel.this.drawCharacters(interval.getFirst(), row, selectionStyle, selectionChars, gfx);
                    }
                }

                @Override
                public void consumeNul(int x, int y, int nulIndex, TextStyle style, CharBuffer characters, int startRow) {
                    Pair<Integer, Integer> interval;
                    int row = y - startRow;
                    if (TerminalPanel.this.mySelection != null && (interval = TerminalPanel.this.mySelection.intersect(nulIndex, row + TerminalPanel.this.myClientScrollOrigin, this.columnCount - nulIndex)) != null) {
                        TextStyle selectionStyle = TerminalPanel.this.getSelectionStyle(style);
                        TerminalPanel.this.drawCharacters(x, row, selectionStyle, characters, gfx);
                        return;
                    }
                    TerminalPanel.this.drawCharacters(x, row, style, characters, gfx);
                }

                @Override
                public void consumeQueue(int x, int y, int nulIndex, int startRow) {
                    if (x < this.columnCount) {
                        this.consumeNul(x, y, nulIndex, TextStyle.EMPTY, new CharBuffer(' ', this.columnCount - x), startRow);
                    }
                }
            });
            int cursorY = this.myCursor.getCoordY();
            if (cursorY < this.getRowCount() && !this.hasUncommittedChars()) {
                int cursorX = this.myCursor.getCoordX();
                Pair<Character, TextStyle> sc = this.myTerminalTextBuffer.getStyledCharAt(cursorX, cursorY);
                String cursorChar = String.valueOf(sc.getFirst());
                if (Character.isHighSurrogate(sc.getFirst().charValue())) {
                    cursorChar = cursorChar + String.valueOf(this.myTerminalTextBuffer.getStyledCharAt(cursorX + 1, cursorY).getFirst());
                }
                TextStyle normalStyle = sc.getSecond() != null ? sc.getSecond() : this.myStyleState.getCurrent();
                TextStyle cursorStyle = this.inSelection(cursorX, cursorY) ? this.getSelectionStyle(normalStyle) : normalStyle;
                this.myCursor.drawCursor(cursorChar, gfx, cursorStyle);
            }
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
        this.resetColorCache();
        this.drawInputMethodUncommitedChars(gfx);
        this.drawMargins(gfx, this.getWidth(), this.getHeight());
    }

    private void resetColorCache() {
        this.myCachedSelectionColor = null;
        this.myCachedFoundPatternColor = null;
    }

    @NotNull
    private TextStyle getSelectionStyle(@NotNull TextStyle style) {
        if (this.mySettingsProvider.useInverseSelectionColor()) {
            return this.getInversedStyle(style);
        }
        TextStyle.Builder builder = style.toBuilder();
        TextStyle selectionStyle = this.getSelectionColor();
        builder.setBackground(selectionStyle.getBackground());
        builder.setForeground(selectionStyle.getForeground());
        if (builder instanceof HyperlinkStyle.Builder) {
            return ((HyperlinkStyle.Builder)builder).build(true);
        }
        return builder.build();
    }

    @NotNull
    private TextStyle getSelectionColor() {
        TextStyle selectionColor = this.myCachedSelectionColor;
        if (selectionColor == null) {
            this.myCachedSelectionColor = selectionColor = this.mySettingsProvider.getSelectionColor();
        }
        return selectionColor;
    }

    @NotNull
    private TextStyle getFoundPatternColor() {
        TextStyle foundPatternColor = this.myCachedFoundPatternColor;
        if (foundPatternColor == null) {
            this.myCachedFoundPatternColor = foundPatternColor = this.mySettingsProvider.getFoundPatternColor();
        }
        return foundPatternColor;
    }

    @NotNull
    private TextStyle getFoundPattern(@NotNull TextStyle style) {
        TextStyle.Builder builder = style.toBuilder();
        TextStyle foundPattern = this.getFoundPatternColor();
        builder.setBackground(foundPattern.getBackground());
        builder.setForeground(foundPattern.getForeground());
        return builder.build();
    }

    private void drawInputMethodUncommitedChars(Graphics2D gfx) {
        if (this.hasUncommittedChars()) {
            int xCoord = (this.myCursor.getCoordX() + 1) * this.myCharSize.width + this.getInsetX();
            int y = this.myCursor.getCoordY() + 1;
            int yCoord = y * this.myCharSize.height - 3;
            int len = this.myInputMethodUncommittedChars.length() * this.myCharSize.width;
            gfx.setColor(this.getBackground());
            gfx.fillRect(xCoord, (y - 1) * this.myCharSize.height - 3, len, this.myCharSize.height);
            gfx.setColor(this.getForeground());
            gfx.setFont(this.myNormalFont);
            gfx.drawString(this.myInputMethodUncommittedChars, xCoord, yCoord);
            Stroke saved = gfx.getStroke();
            BasicStroke dotted = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);
            gfx.setStroke(dotted);
            gfx.drawLine(xCoord, yCoord, xCoord + len, yCoord);
            gfx.setStroke(saved);
        }
    }

    private boolean hasUncommittedChars() {
        return this.myInputMethodUncommittedChars != null && this.myInputMethodUncommittedChars.length() > 0;
    }

    private boolean inSelection(int x, int y) {
        return this.mySelection != null && this.mySelection.contains(new Point(x, y));
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        this.handleKeyEvent(e);
    }

    public void handleKeyEvent(@NotNull KeyEvent e) {
        block3: {
            int id;
            block2: {
                id = e.getID();
                if (id != 401) break block2;
                for (KeyListener keyListener : this.myCustomKeyListeners) {
                    keyListener.keyPressed(e);
                }
                break block3;
            }
            if (id != 400) break block3;
            for (KeyListener keyListener : this.myCustomKeyListeners) {
                keyListener.keyTyped(e);
            }
        }
    }

    private void updateSelectionEnd(Point selectionEnd) {
        this.mySelection.updateEnd(selectionEnd);
        this.updateSelection(this.mySelection);
    }

    private void updateSelection(@Nullable TerminalSelection selection) {
        this.mySelection = selection;
        for (TerminalSelectionChangesListener selectionListener : this.selectionChangesListeners) {
            selectionListener.selectionChanged(selection);
        }
    }

    public int getPixelWidth() {
        return this.myCharSize.width * this.myTermSize.getColumns() + this.getInsetX();
    }

    public int getPixelHeight() {
        return this.myCharSize.height * this.myTermSize.getRows();
    }

    private int getColumnCount() {
        return this.myTermSize.getColumns();
    }

    private int getRowCount() {
        return this.myTermSize.getRows();
    }

    @Override
    public String getWindowTitle() {
        return this.myWindowTitle;
    }

    @Override
    @NotNull
    public Color getWindowForeground() {
        return this.toForeground(this.mySettingsProvider.getDefaultForeground());
    }

    @Override
    @NotNull
    public Color getWindowBackground() {
        return this.toBackground(this.mySettingsProvider.getDefaultBackground());
    }

    @NotNull
    private java.awt.Color getEffectiveForeground(@NotNull TextStyle style) {
        Color color = style.hasOption(TextStyle.Option.INVERSE) ? this.getBackground(style) : this.getForeground(style);
        return AwtTransformers.toAwtColor(color);
    }

    @NotNull
    private java.awt.Color getEffectiveBackground(@NotNull TextStyle style) {
        Color color = style.hasOption(TextStyle.Option.INVERSE) ? this.getForeground(style) : this.getBackground(style);
        return AwtTransformers.toAwtColor(color);
    }

    @NotNull
    private Color getForeground(@NotNull TextStyle style) {
        TerminalColor foreground = style.getForeground();
        return foreground != null ? this.toForeground(foreground) : this.getWindowForeground();
    }

    @NotNull
    private Color toForeground(@NotNull TerminalColor terminalColor) {
        if (terminalColor.isIndexed()) {
            return this.getPalette().getForeground(terminalColor);
        }
        return terminalColor.toColor();
    }

    @NotNull
    private Color getBackground(@NotNull TextStyle style) {
        TerminalColor background = style.getBackground();
        return background != null ? this.toBackground(background) : this.getWindowBackground();
    }

    @NotNull
    private Color toBackground(@NotNull TerminalColor terminalColor) {
        if (terminalColor.isIndexed()) {
            return this.getPalette().getBackground(terminalColor);
        }
        return terminalColor.toColor();
    }

    protected int getInsetX() {
        return 4;
    }

    public void addTerminalMouseListener(final TerminalMouseListener listener) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (TerminalPanel.this.mySettingsProvider.enableMouseReporting() && TerminalPanel.this.isRemoteMouseAction(e)) {
                    Point p = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    listener.mousePressed(p.x, p.y, new AwtMouseEvent(e));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TerminalPanel.this.mySettingsProvider.enableMouseReporting() && TerminalPanel.this.isRemoteMouseAction(e)) {
                    Point p = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    listener.mouseReleased(p.x, p.y, new AwtMouseEvent(e));
                }
            }
        });
        this.addMouseWheelListener(e -> {
            if (this.mySettingsProvider.enableMouseReporting() && this.isRemoteMouseAction(e)) {
                this.updateSelection(null);
                Point p = this.panelToCharCoords(e.getPoint());
                listener.mouseWheelMoved(p.x, p.y, new AwtMouseWheelEvent(e));
            } else if (this.myTerminalTextBuffer.isUsingAlternateBuffer() && this.mySettingsProvider.sendArrowKeysInAlternativeMode()) {
                byte[] arrowKeys = e.getWheelRotation() < 0 ? this.myTerminalStarter.getTerminal().getCodeForKey(38, 0) : this.myTerminalStarter.getTerminal().getCodeForKey(40, 0);
                for (int i = 0; i < Math.abs(e.getUnitsToScroll()); ++i) {
                    this.myTerminalStarter.sendBytes(arrowKeys, false);
                }
                e.consume();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (TerminalPanel.this.mySettingsProvider.enableMouseReporting() && TerminalPanel.this.isRemoteMouseAction(e)) {
                    Point p = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    listener.mouseMoved(p.x, p.y, new AwtMouseEvent(e));
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TerminalPanel.this.mySettingsProvider.enableMouseReporting() && TerminalPanel.this.isRemoteMouseAction(e)) {
                    Point p = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    listener.mouseDragged(p.x, p.y, new AwtMouseEvent(e));
                }
            }
        });
    }

    @NotNull
    KeyListener getTerminalKeyListener() {
        return this.myTerminalKeyHandler;
    }

    private int getBlinkingPeriod() {
        if (this.myBlinkingPeriod != this.mySettingsProvider.caretBlinkingMs()) {
            this.setBlinkingPeriod(this.mySettingsProvider.caretBlinkingMs());
        }
        return this.myBlinkingPeriod;
    }

    protected void drawImage(Graphics2D g, BufferedImage image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    @NotNull
    private TextStyle getInversedStyle(@NotNull TextStyle style) {
        TextStyle.Builder builder = new TextStyle.Builder(style);
        builder.setOption(TextStyle.Option.INVERSE, !style.hasOption(TextStyle.Option.INVERSE));
        if (style.getForeground() == null) {
            builder.setForeground(this.myStyleState.getDefaultForeground());
        }
        if (style.getBackground() == null) {
            builder.setBackground(this.myStyleState.getDefaultBackground());
        }
        return builder.build();
    }

    private void drawCharacters(int x, int y, TextStyle style, CharBuffer buf, Graphics2D gfx) {
        this.drawCharacters(x, y, style, buf, gfx, true);
    }

    private void drawCharacters(int x, int y, TextStyle style, CharBuffer buf, Graphics2D gfx, boolean includeSpaceBetweenLines) {
        HyperlinkStyle hyperlinkStyle;
        if (this.myTextBlinkingTracker.shouldBlinkNow(style)) {
            style = this.getInversedStyle(style);
        }
        int xCoord = x * this.myCharSize.width + this.getInsetX();
        int yCoord = y * this.myCharSize.height + (includeSpaceBetweenLines ? 0 : this.mySpaceBetweenLines / 2);
        if (xCoord < 0 || xCoord > this.getWidth() || yCoord < 0 || yCoord > this.getHeight()) {
            return;
        }
        int textLength = CharUtils.getTextLengthDoubleWidthAware(buf.getBuf(), buf.getStart(), buf.length(), this.mySettingsProvider.ambiguousCharsAreDoubleWidth());
        int height = Math.min(this.myCharSize.height - (includeSpaceBetweenLines ? 0 : this.mySpaceBetweenLines), this.getHeight() - yCoord);
        int width = Math.min(textLength * this.myCharSize.width, this.getWidth() - xCoord);
        if (style instanceof HyperlinkStyle && ((hyperlinkStyle = (HyperlinkStyle)style).getHighlightMode() == HyperlinkStyle.HighlightMode.ALWAYS || this.isHoveredHyperlink(hyperlinkStyle) && hyperlinkStyle.getHighlightMode() == HyperlinkStyle.HighlightMode.HOVER)) {
            style = hyperlinkStyle.getHighlightStyle();
        }
        java.awt.Color backgroundColor = this.getEffectiveBackground(style);
        gfx.setColor(backgroundColor);
        gfx.fillRect(xCoord, yCoord, width, height);
        if (buf.isNul()) {
            return;
        }
        gfx.setColor(this.getStyleForeground(style));
        this.drawChars(x, y, buf, style, gfx);
        if (style.hasOption(TextStyle.Option.UNDERLINED)) {
            int baseLine = (y + 1) * this.myCharSize.height - this.mySpaceBetweenLines / 2 - this.myDescent;
            int lineY = baseLine + 3;
            gfx.drawLine(xCoord, lineY, (x + textLength) * this.myCharSize.width + this.getInsetX(), lineY);
        }
    }

    private boolean isHoveredHyperlink(@NotNull HyperlinkStyle link) {
        return this.myHoveredHyperlink == link.getLinkInfo();
    }

    private void drawChars(int x, int y, @NotNull CharBuffer buf, @NotNull TextStyle style, @NotNull Graphics2D gfx) {
        int endOffset;
        CharBuffer renderingBuffer = this.mySettingsProvider.DECCompatibilityMode() && style.hasOption(TextStyle.Option.BOLD) ? CharUtils.heavyDecCompatibleBuffer(buf) : buf;
        BreakIterator iterator2 = BreakIterator.getCharacterInstance();
        char[] text = renderingBuffer.clone().getBuf();
        iterator2.setText(new String(text));
        int startOffset = 0;
        while ((endOffset = iterator2.next()) != -1) {
            int effectiveEndOffset = TerminalPanel.shiftDwcToEnd(text, startOffset, endOffset = TerminalPanel.extendEndOffset(text, iterator2, startOffset, endOffset));
            if (effectiveEndOffset == startOffset) {
                startOffset = endOffset;
                continue;
            }
            Font font = this.getFontToDisplay(text, startOffset, effectiveEndOffset, style);
            gfx.setFont(font);
            int descent = gfx.getFontMetrics(font).getDescent();
            int baseLine = (y + 1) * this.myCharSize.height - this.mySpaceBetweenLines / 2 - descent;
            int charWidth = this.myCharSize.width;
            int xCoord = (x + startOffset) * charWidth + this.getInsetX();
            int yCoord = y * this.myCharSize.height + this.mySpaceBetweenLines / 2;
            gfx.setClip(xCoord, yCoord, this.getWidth() - xCoord, this.getHeight() - yCoord);
            int emptyCells = endOffset - startOffset;
            if (emptyCells >= 2) {
                int drawnWidth = gfx.getFontMetrics(font).charsWidth(text, startOffset, effectiveEndOffset - startOffset);
                int emptySpace = Math.max(0, emptyCells * charWidth - drawnWidth);
                xCoord += emptySpace / 2;
            }
            gfx.drawChars(text, startOffset, effectiveEndOffset - startOffset, xCoord, baseLine);
            startOffset = endOffset;
        }
        gfx.setClip(null);
    }

    private static int shiftDwcToEnd(char[] text, int startOffset, int endOffset) {
        int ind = startOffset;
        for (int i = startOffset; i < endOffset; ++i) {
            if (text[i] == '\ue000') continue;
            text[ind++] = text[i];
        }
        Arrays.fill(text, ind, endOffset, '\ue000');
        return ind;
    }

    private static int extendEndOffset(char[] text, @NotNull BreakIterator iterator2, int startOffset, int endOffset) {
        int newEndOffset;
        while (TerminalPanel.shouldExtend(text, startOffset, endOffset) && (newEndOffset = iterator2.next()) != -1) {
            if (newEndOffset - endOffset == 1 && !TerminalPanel.isUnicodePart(text, endOffset)) {
                iterator2.previous();
                break;
            }
            startOffset = endOffset;
            endOffset = newEndOffset;
        }
        return endOffset;
    }

    private static boolean shouldExtend(char[] text, int startOffset, int endOffset) {
        if (endOffset - startOffset > 1) {
            return true;
        }
        if (TerminalPanel.isFormatChar(text, startOffset, endOffset)) {
            return true;
        }
        return endOffset < text.length && text[endOffset] == '\ue000';
    }

    private static boolean isUnicodePart(char[] text, int ind) {
        if (TerminalPanel.isFormatChar(text, ind, ind + 1)) {
            return true;
        }
        if (text[ind] == '\ue000') {
            return true;
        }
        return Character.UnicodeBlock.of(text[ind]) == Character.UnicodeBlock.MISCELLANEOUS_SYMBOLS_AND_ARROWS;
    }

    private static boolean isFormatChar(char[] text, int start, int end) {
        char charCode;
        return end - start == 1 && (charCode = text[start]) >= '\u200c' && (charCode <= '\u200f' || charCode >= '\u2028' && charCode <= '\u202e' || charCode >= '\u206a' && charCode <= '\u206f');
    }

    @NotNull
    private java.awt.Color getStyleForeground(@NotNull TextStyle style) {
        java.awt.Color foreground = this.getEffectiveForeground(style);
        if (style.hasOption(TextStyle.Option.DIM)) {
            java.awt.Color background = this.getEffectiveBackground(style);
            foreground = new java.awt.Color((foreground.getRed() + background.getRed()) / 2, (foreground.getGreen() + background.getGreen()) / 2, (foreground.getBlue() + background.getBlue()) / 2, foreground.getAlpha());
        }
        return foreground;
    }

    @NotNull
    protected Font getFontToDisplay(char[] text, int start, int end, @NotNull TextStyle style) {
        boolean bold = style.hasOption(TextStyle.Option.BOLD);
        boolean italic = style.hasOption(TextStyle.Option.ITALIC);
        if (bold && this.mySettingsProvider.DECCompatibilityMode() && CharacterSets.isDecBoxChar(text[start])) {
            return this.myNormalFont;
        }
        return bold ? (italic ? this.myBoldItalicFont : this.myBoldFont) : (italic ? this.myItalicFont : this.myNormalFont);
    }

    private ColorPalette getPalette() {
        return this.mySettingsProvider.getTerminalColorPalette();
    }

    private void drawMargins(Graphics2D gfx, int width, int height) {
        gfx.setColor(this.getBackground());
        gfx.fillRect(0, height, this.getWidth(), this.getHeight() - height);
        gfx.fillRect(width, 0, this.getWidth() - width, this.getHeight());
    }

    @Override
    public void scrollArea(int scrollRegionTop, int scrollRegionSize, int dy) {
        this.scrollDy.addAndGet(dy);
        this.updateSelection(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollToShowAllOutput() {
        this.myTerminalTextBuffer.lock();
        try {
            final int historyLines = this.myTerminalTextBuffer.getHistoryLinesCount();
            if (historyLines > 0) {
                final int termHeight = this.myTermSize.getRows();
                this.myBoundedRangeModel.setRangeProperties(-historyLines, historyLines + termHeight, -historyLines, termHeight, false);
                final TerminalModelListener modelListener = new TerminalModelListener(){

                    @Override
                    public void modelChanged() {
                        int zeroBasedCursorY = TerminalPanel.this.myCursor.myCursorCoordinates.y - 1;
                        if (zeroBasedCursorY + historyLines >= termHeight) {
                            TerminalPanel.this.myTerminalTextBuffer.removeModelListener(this);
                            SwingUtilities.invokeLater(() -> {
                                TerminalPanel.this.myTerminalTextBuffer.lock();
                                try {
                                    TerminalPanel.this.myBoundedRangeModel.setRangeProperties(0, TerminalPanel.this.myTermSize.getRows(), -TerminalPanel.this.myTerminalTextBuffer.getHistoryLinesCount(), TerminalPanel.this.myTermSize.getRows(), false);
                                }
                                finally {
                                    TerminalPanel.this.myTerminalTextBuffer.unlock();
                                }
                            });
                        }
                    }
                };
                this.myTerminalTextBuffer.addModelListener(modelListener);
                this.myBoundedRangeModel.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        TerminalPanel.this.myBoundedRangeModel.removeChangeListener(this);
                        TerminalPanel.this.myTerminalTextBuffer.removeModelListener(modelListener);
                    }
                });
            }
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    private void updateScrolling(boolean forceUpdate) {
        int dy = this.scrollDy.getAndSet(0);
        boolean historyBufferLineCountChanged = this.myHistoryBufferLineCountChanged.getAndSet(false);
        if (dy == 0 && !forceUpdate && !historyBufferLineCountChanged) {
            return;
        }
        if (this.myScrollingEnabled) {
            int value = this.myBoundedRangeModel.getValue();
            int historyLineCount = this.myTerminalTextBuffer.getHistoryLinesCount();
            if (value == 0) {
                this.myBoundedRangeModel.setRangeProperties(0, this.myTermSize.getRows(), -historyLineCount, this.myTermSize.getRows(), false);
            } else {
                this.myBoundedRangeModel.setRangeProperties(Math.min(Math.max(value + dy, -historyLineCount), this.myTermSize.getRows()), this.myTermSize.getRows(), -historyLineCount, this.myTermSize.getRows(), false);
            }
        } else {
            this.myBoundedRangeModel.setRangeProperties(0, this.myTermSize.getRows(), 0, this.myTermSize.getRows(), false);
        }
    }

    @Override
    public void setCursor(int x, int y) {
        this.myCursor.setX(x);
        this.myCursor.setY(y);
    }

    @Override
    public void setCursorShape(@Nullable CursorShape cursorShape) {
        this.myCursor.setShape(cursorShape);
    }

    public void setDefaultCursorShape(@NotNull CursorShape defaultCursorShape) {
        this.myCursor.setDefaultShape(defaultCursorShape);
    }

    @Override
    public void beep() {
        if (this.mySettingsProvider.audibleBell()) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Nullable
    public Rectangle getBounds(@NotNull TerminalLineIntervalHighlighting highlighting) {
        TerminalLine line = highlighting.getLine();
        int index = this.myTerminalTextBuffer.findScreenLineIndex(line);
        if (index >= 0 && !highlighting.isDisposed()) {
            return this.getBounds(new LineCellInterval(index, highlighting.getStartOffset(), highlighting.getEndOffset() + 1));
        }
        return null;
    }

    @NotNull
    private Rectangle getBounds(@NotNull LineCellInterval cellInterval) {
        java.awt.Point topLeft = new java.awt.Point(cellInterval.getStartColumn() * this.myCharSize.width + this.getInsetX(), cellInterval.getLine() * this.myCharSize.height);
        return new Rectangle(topLeft, new Dimension(this.myCharSize.width * cellInterval.getCellCount(), this.myCharSize.height));
    }

    @Deprecated
    public BoundedRangeModel getBoundedRangeModel() {
        return this.myBoundedRangeModel;
    }

    @NotNull
    public BoundedRangeModel getVerticalScrollModel() {
        return this.myBoundedRangeModel;
    }

    public TerminalTextBuffer getTerminalTextBuffer() {
        return this.myTerminalTextBuffer;
    }

    @Override
    @Nullable
    public TerminalSelection getSelection() {
        return this.mySelection;
    }

    @Override
    public boolean ambiguousCharsAreDoubleWidth() {
        return this.mySettingsProvider.ambiguousCharsAreDoubleWidth();
    }

    @Override
    public void setBracketedPasteMode(boolean bracketedPasteModeEnabled) {
        this.myBracketedPasteMode = bracketedPasteModeEnabled;
    }

    @Deprecated(forRemoval=true)
    public LinesBuffer getScrollBuffer() {
        return this.myTerminalTextBuffer.getHistoryBuffer();
    }

    public LinesStorage getScrollLinesStorage() {
        return this.myTerminalTextBuffer.getHistoryLinesStorage();
    }

    @Override
    public void setCursorVisible(boolean isCursorVisible) {
        this.myCursor.setShouldDrawCursor(isCursorVisible);
    }

    @NotNull
    protected JPopupMenu createPopupMenu(@NotNull TerminalActionProvider actionProvider) {
        JPopupMenu popup = new JPopupMenu();
        TerminalAction.fillMenu(popup, actionProvider);
        return popup;
    }

    @NotNull
    private TerminalActionProvider getTerminalActionProvider(@Nullable LinkInfo linkInfo, final @NotNull MouseEvent e) {
        final LinkInfoEx.PopupMenuGroupProvider popupMenuGroupProvider = LinkInfoEx.getPopupMenuGroupProvider(linkInfo);
        if (popupMenuGroupProvider != null) {
            return new TerminalActionProvider(){

                @Override
                public List<TerminalAction> getActions() {
                    return popupMenuGroupProvider.getPopupMenuGroup(e);
                }

                @Override
                public TerminalActionProvider getNextProvider() {
                    return TerminalPanel.this;
                }

                @Override
                public void setNextProvider(TerminalActionProvider provider) {
                }
            };
        }
        return this;
    }

    @Override
    public void useAlternateScreenBuffer(boolean useAlternateScreenBuffer) {
        this.myScrollingEnabled = !useAlternateScreenBuffer;
        SwingUtilities.invokeLater(() -> {
            this.updateScrolling(true);
            if (this.myUsingAlternateBuffer != this.myTerminalTextBuffer.isUsingAlternateBuffer()) {
                this.myUsingAlternateBuffer = this.myTerminalTextBuffer.isUsingAlternateBuffer();
                if (this.mySettingsProvider.shouldDisableLineSpacingForAlternateScreenBuffer()) {
                    Timer timer = new Timer(10, e -> {});
                    timer.addActionListener(e -> {
                        this.reinitFontAndResize();
                        timer.stop();
                    });
                    timer.start();
                }
            }
        });
    }

    public TerminalOutputStream getTerminalOutputStream() {
        return this.myTerminalStarter;
    }

    @Override
    public void setWindowTitle(@NotNull String windowTitle) {
        this.myWindowTitle = windowTitle;
    }

    @Override
    public List<TerminalAction> getActions() {
        return List.of(new TerminalAction(this.mySettingsProvider.getOpenUrlActionPresentation(), input -> this.openSelectionAsURL()).withEnabledSupplier(this::selectionTextIsUrl), new TerminalAction(this.mySettingsProvider.getCopyActionPresentation(), this::handleCopy){

            @Override
            public boolean isEnabled(@Nullable KeyEvent e) {
                return e != null || TerminalPanel.this.mySelection != null;
            }
        }.withMnemonicKey(67), new TerminalAction(this.mySettingsProvider.getPasteActionPresentation(), input -> {
            this.handlePaste();
            return true;
        }).withMnemonicKey(80).withEnabledSupplier(() -> this.getClipboardString() != null), new TerminalAction(this.mySettingsProvider.getSelectAllActionPresentation(), input -> {
            this.selectAll();
            return true;
        }), new TerminalAction(this.mySettingsProvider.getClearBufferActionPresentation(), input -> {
            this.clearBuffer();
            return true;
        }).withMnemonicKey(75).withEnabledSupplier(() -> !this.myTerminalTextBuffer.isUsingAlternateBuffer()).separatorBefore(true), new TerminalAction(this.mySettingsProvider.getPageUpActionPresentation(), input -> {
            this.pageUp();
            return true;
        }).withEnabledSupplier(() -> !this.myTerminalTextBuffer.isUsingAlternateBuffer()).separatorBefore(true), new TerminalAction(this.mySettingsProvider.getPageDownActionPresentation(), input -> {
            this.pageDown();
            return true;
        }).withEnabledSupplier(() -> !this.myTerminalTextBuffer.isUsingAlternateBuffer()), new TerminalAction(this.mySettingsProvider.getLineUpActionPresentation(), input -> {
            this.scrollUp();
            return true;
        }).withEnabledSupplier(() -> !this.myTerminalTextBuffer.isUsingAlternateBuffer()).separatorBefore(true), new TerminalAction(this.mySettingsProvider.getLineDownActionPresentation(), input -> {
            this.scrollDown();
            return true;
        }));
    }

    public void selectAll() {
        this.updateSelection(new TerminalSelection(new Point(0, -this.myTerminalTextBuffer.getHistoryLinesCount()), new Point(this.myTermSize.getColumns(), this.myTerminalTextBuffer.getScreenLinesCount())));
    }

    @NotNull
    private Boolean selectionTextIsUrl() {
        String selectionText = this.getSelectionText();
        if (selectionText != null) {
            try {
                URI uri = new URI(selectionText);
                uri.toURL();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    private String getSelectionText() {
        Pair<Point, Point> points;
        if (this.mySelection != null && ((points = this.mySelection.pointsForRun(this.myTermSize.getColumns())).getFirst() != null || points.getSecond() != null)) {
            return SelectionUtil.getSelectionText(points.getFirst(), points.getSecond(), this.myTerminalTextBuffer);
        }
        return null;
    }

    protected boolean openSelectionAsURL() {
        if (Desktop.isDesktopSupported()) {
            try {
                String selectionText = this.getSelectionText();
                if (selectionText != null) {
                    Desktop.getDesktop().browse(new URI(selectionText));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void clearBuffer() {
        this.clearBuffer(true);
    }

    protected void clearBuffer(boolean keepLastLine) {
        if (!this.myTerminalTextBuffer.isUsingAlternateBuffer()) {
            this.myTerminalTextBuffer.clearHistory();
            if (this.myCoordsAccessor != null) {
                if (keepLastLine) {
                    if (this.myCoordsAccessor.getY() > 0) {
                        TerminalLine lastLine = this.myTerminalTextBuffer.getLine(this.myCoordsAccessor.getY() - 1);
                        this.myTerminalTextBuffer.clearScreenBuffer();
                        this.myCoordsAccessor.setY(0);
                        this.myCursor.setY(1);
                        this.myTerminalTextBuffer.addLine(lastLine);
                    }
                } else {
                    this.myTerminalTextBuffer.clearScreenBuffer();
                    this.myCoordsAccessor.setX(0);
                    this.myCoordsAccessor.setY(1);
                    this.myCursor.setX(0);
                    this.myCursor.setY(1);
                }
            }
            this.myBoundedRangeModel.setValue(0);
            this.updateScrolling(true);
            this.myClientScrollOrigin = this.myBoundedRangeModel.getValue();
        }
    }

    @Override
    public TerminalActionProvider getNextProvider() {
        return this.myNextActionProvider;
    }

    @Override
    public void setNextProvider(TerminalActionProvider provider) {
        this.myNextActionProvider = provider;
    }

    private boolean processTerminalKeyPressed(KeyEvent e) {
        if (this.hasUncommittedChars()) {
            return false;
        }
        try {
            int keycode = e.getKeyCode();
            char keychar = e.getKeyChar();
            if (keycode == 127 && keychar == '.') {
                this.myTerminalStarter.sendBytes(new byte[]{46}, true);
                return true;
            }
            if (keychar == ' ' && (e.getModifiersEx() & 0x80) != 0) {
                this.myTerminalStarter.sendBytes(new byte[]{0}, true);
                return true;
            }
            byte[] code = this.myTerminalStarter.getTerminal().getCodeForKey(keycode, e.getModifiers());
            if (code != null) {
                this.myTerminalStarter.sendBytes(code, true);
                if (this.mySettingsProvider.scrollToBottomOnTyping() && TerminalPanel.isCodeThatScrolls(keycode)) {
                    this.scrollToBottom();
                }
                return true;
            }
            if (TerminalPanel.isAltPressedOnly(e) && Character.isDefined(keychar) && this.mySettingsProvider.altSendsEscape()) {
                this.myTerminalStarter.sendString(new String(new char[]{'\u001b', TerminalPanel.simpleMapKeyCodeToChar(e)}), true);
                return true;
            }
            if (Character.isISOControl(keychar)) {
                return this.processCharacter(e);
            }
        }
        catch (Exception ex) {
            LOG.error("Error sending pressed key to emulator", ex);
        }
        return false;
    }

    private static char simpleMapKeyCodeToChar(@NotNull KeyEvent e) {
        if ((e.getModifiersEx() & 0x40) != 0) {
            return Character.toUpperCase((char)e.getKeyCode());
        }
        return Character.toLowerCase((char)e.getKeyCode());
    }

    private static boolean isAltPressedOnly(@NotNull KeyEvent e) {
        int modifiersEx = e.getModifiersEx();
        return (modifiersEx & 0x200) != 0 && (modifiersEx & 0x2000) == 0 && (modifiersEx & 0x80) == 0 && (modifiersEx & 0x40) == 0;
    }

    private boolean processCharacter(@NotNull KeyEvent e) {
        if (TerminalPanel.isAltPressedOnly(e) && this.mySettingsProvider.altSendsEscape()) {
            return false;
        }
        char keyChar = e.getKeyChar();
        char[] obuffer = new char[]{keyChar};
        if (keyChar == '`' && (e.getModifiersEx() & 0x100) != 0) {
            return false;
        }
        this.myTerminalStarter.sendString(new String(obuffer), true);
        if (this.mySettingsProvider.scrollToBottomOnTyping()) {
            this.scrollToBottom();
        }
        return true;
    }

    private static boolean isCodeThatScrolls(int keycode) {
        return keycode == 38 || keycode == 40 || keycode == 37 || keycode == 39 || keycode == 8 || keycode == 155 || keycode == 127 || keycode == 10 || keycode == 36 || keycode == 35 || keycode == 33 || keycode == 34;
    }

    private boolean processTerminalKeyTyped(KeyEvent e) {
        if (this.hasUncommittedChars()) {
            return false;
        }
        if (!Character.isISOControl(e.getKeyChar())) {
            try {
                return this.processCharacter(e);
            }
            catch (Exception ex) {
                LOG.error("Error sending typed key to emulator", ex);
            }
        }
        return false;
    }

    private void handlePaste() {
        this.pasteFromClipboard(false);
    }

    private void handlePasteSelection() {
        this.pasteFromClipboard(true);
    }

    private void handleCopy(boolean unselect, boolean useSystemSelectionClipboardIfAvailable) {
        if (this.mySelection != null) {
            Pair<Point, Point> points = this.mySelection.pointsForRun(this.myTermSize.getColumns());
            this.copySelection(points.getFirst(), points.getSecond(), useSystemSelectionClipboardIfAvailable);
            if (unselect) {
                this.updateSelection(null);
                this.repaint();
            }
        }
    }

    private boolean handleCopy(@Nullable KeyEvent e) {
        boolean ctrlC = e != null && e.getKeyCode() == 67 && e.getModifiersEx() == 128;
        boolean sendCtrlC = ctrlC && this.mySelection == null;
        this.handleCopy(ctrlC, false);
        return !sendCtrlC;
    }

    private void handleCopyOnSelect() {
        this.handleCopy(false, true);
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent e) {
        int commitCount = e.getCommittedCharacterCount();
        if (commitCount > 0) {
            this.myInputMethodUncommittedChars = null;
            AttributedCharacterIterator text = e.getText();
            if (text != null) {
                StringBuilder sb = new StringBuilder();
                char c = text.first();
                while (commitCount > 0) {
                    if (c >= ' ' && c != '\u007f') {
                        sb.append(c);
                    }
                    c = text.next();
                    --commitCount;
                }
                if (sb.length() > 0) {
                    this.myTerminalStarter.sendString(sb.toString(), true);
                }
            }
        } else {
            this.myInputMethodUncommittedChars = TerminalPanel.uncommittedChars(e.getText());
        }
    }

    private static String uncommittedChars(@Nullable AttributedCharacterIterator text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        char c = text.first();
        while (c != '\uffff') {
            if (c >= ' ' && c != '\u007f') {
                sb.append(c);
            }
            c = text.next();
        }
        return sb.toString();
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return new MyInputMethodRequests();
    }

    public void dispose() {
        this.myRepaintTimer.stop();
    }

    private class TerminalCursor {
        private boolean myCursorIsShown;
        private final Point myCursorCoordinates = new Point();
        @NotNull
        private CursorShape myDefaultCursorShape = CursorShape.BLINK_BLOCK;
        @Nullable
        private CursorShape myShape;
        private boolean myShouldDrawCursor = true;
        private long myLastCursorChange;
        private boolean myCursorHasChanged;

        private TerminalCursor() {
        }

        public void setX(int x) {
            this.myCursorCoordinates.x = x;
            this.cursorChanged();
        }

        public void setY(int y) {
            this.myCursorCoordinates.y = y;
            this.cursorChanged();
        }

        public int getCoordX() {
            if (TerminalPanel.this.myTypeAheadManager != null) {
                return TerminalPanel.this.myTypeAheadManager.getCursorX() - 1;
            }
            return this.myCursorCoordinates.x;
        }

        public int getCoordY() {
            return this.myCursorCoordinates.y - 1 - TerminalPanel.this.myClientScrollOrigin;
        }

        public void setShouldDrawCursor(boolean shouldDrawCursor) {
            this.myShouldDrawCursor = shouldDrawCursor;
        }

        public boolean isBlinking() {
            return this.getEffectiveShape().isBlinking() && TerminalPanel.this.getBlinkingPeriod() > 0;
        }

        public void cursorChanged() {
            this.myCursorHasChanged = true;
            this.myLastCursorChange = System.currentTimeMillis();
            TerminalPanel.this.repaint();
        }

        private boolean cursorShouldChangeBlinkState(long currentTime) {
            return currentTime - this.myLastCursorChange > (long)TerminalPanel.this.getBlinkingPeriod();
        }

        public void changeStateIfNeeded() {
            if (!TerminalPanel.this.isFocusOwner()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this.cursorShouldChangeBlinkState(currentTime)) {
                this.myCursorIsShown = !this.myCursorIsShown;
                this.myLastCursorChange = currentTime;
                this.myCursorHasChanged = false;
                TerminalPanel.this.repaint();
            }
        }

        private TerminalCursorState computeBlinkingState() {
            if (!this.isBlinking() || this.myCursorHasChanged || this.myCursorIsShown) {
                return TerminalCursorState.SHOWING;
            }
            return TerminalCursorState.HIDDEN;
        }

        private TerminalCursorState computeCursorState() {
            if (!this.myShouldDrawCursor) {
                return TerminalCursorState.HIDDEN;
            }
            if (!TerminalPanel.this.isFocusOwner()) {
                return TerminalCursorState.NO_FOCUS;
            }
            return this.computeBlinkingState();
        }

        void drawCursor(String c, Graphics2D gfx, TextStyle style) {
            TerminalCursorState state = this.computeCursorState();
            if (state == TerminalCursorState.HIDDEN) {
                return;
            }
            int x = this.getCoordX();
            int y = this.getCoordY();
            if (y < 0 || y >= TerminalPanel.this.myTermSize.getRows()) {
                return;
            }
            CharBuffer buf = new CharBuffer(c);
            int xCoord = x * TerminalPanel.this.myCharSize.width + TerminalPanel.this.getInsetX();
            int yCoord = y * TerminalPanel.this.myCharSize.height;
            int textLength = CharUtils.getTextLengthDoubleWidthAware(buf.getBuf(), buf.getStart(), buf.length(), TerminalPanel.this.mySettingsProvider.ambiguousCharsAreDoubleWidth());
            int height = Math.min(TerminalPanel.this.myCharSize.height, TerminalPanel.this.getHeight() - yCoord);
            int width = Math.min(textLength * TerminalPanel.this.myCharSize.width, TerminalPanel.this.getWidth() - xCoord);
            int lineStrokeSize = 2;
            java.awt.Color fgColor = TerminalPanel.this.getEffectiveForeground(style);
            TextStyle inversedStyle = TerminalPanel.this.getInversedStyle(style);
            java.awt.Color inverseBg = TerminalPanel.this.getEffectiveBackground(inversedStyle);
            switch (this.getEffectiveShape()) {
                case BLINK_BLOCK: 
                case STEADY_BLOCK: {
                    if (state == TerminalCursorState.SHOWING) {
                        gfx.setColor(inverseBg);
                        gfx.fillRect(xCoord, yCoord, width, height);
                        TerminalPanel.this.drawCharacters(x, y, inversedStyle, buf, gfx);
                        break;
                    }
                    gfx.setColor(fgColor);
                    gfx.drawRect(xCoord, yCoord, width, height);
                    break;
                }
                case BLINK_UNDERLINE: 
                case STEADY_UNDERLINE: {
                    gfx.setColor(fgColor);
                    gfx.fillRect(xCoord, yCoord + height, width, lineStrokeSize);
                    break;
                }
                case BLINK_VERTICAL_BAR: 
                case STEADY_VERTICAL_BAR: {
                    gfx.setColor(fgColor);
                    gfx.fillRect(xCoord, yCoord, lineStrokeSize, height);
                }
            }
        }

        void setShape(@Nullable CursorShape shape) {
            this.myShape = shape;
        }

        @NotNull
        CursorShape getEffectiveShape() {
            return Objects.requireNonNullElse(this.myShape, this.myDefaultCursorShape);
        }

        private void setDefaultShape(@NotNull CursorShape defaultShape) {
            this.myDefaultCursorShape = defaultShape;
        }
    }

    private class TerminalKeyHandler
    extends KeyAdapter {
        private boolean myIgnoreNextKeyTypedEvent;

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            this.myIgnoreNextKeyTypedEvent = false;
            if (TerminalAction.processEvent(TerminalPanel.this, e) || TerminalPanel.this.processTerminalKeyPressed(e)) {
                e.consume();
                this.myIgnoreNextKeyTypedEvent = true;
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (this.myIgnoreNextKeyTypedEvent || TerminalPanel.this.processTerminalKeyTyped(e)) {
                e.consume();
            }
        }
    }

    static class WeakRedrawTimer
    implements ActionListener {
        private WeakReference<TerminalPanel> ref;

        public WeakRedrawTimer(TerminalPanel terminalPanel) {
            this.ref = new WeakReference<TerminalPanel>(terminalPanel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TerminalPanel terminalPanel = (TerminalPanel)this.ref.get();
            if (terminalPanel != null) {
                terminalPanel.myCursor.changeStateIfNeeded();
                terminalPanel.myTextBlinkingTracker.updateState(terminalPanel.mySettingsProvider, terminalPanel);
                terminalPanel.updateScrolling(false);
                if (terminalPanel.needRepaint.getAndSet(false)) {
                    try {
                        terminalPanel.doRepaint();
                    }
                    catch (Exception ex) {
                        LOG.error("Error while terminal panel redraw", ex);
                    }
                }
            } else {
                Timer timer = (Timer)e.getSource();
                timer.removeActionListener(this);
                timer.stop();
            }
        }
    }

    private class MyInputMethodRequests
    implements InputMethodRequests {
        private MyInputMethodRequests() {
        }

        @Override
        public Rectangle getTextLocation(TextHitInfo offset) {
            Rectangle r = new Rectangle(TerminalPanel.this.myCursor.getCoordX() * TerminalPanel.this.myCharSize.width + TerminalPanel.this.getInsetX(), (TerminalPanel.this.myCursor.getCoordY() + 1) * TerminalPanel.this.myCharSize.height, 0, 0);
            java.awt.Point p = TerminalPanel.this.getLocationOnScreen();
            r.translate(p.x, p.y);
            return r;
        }

        @Override
        @Nullable
        public TextHitInfo getLocationOffset(int x, int y) {
            return null;
        }

        @Override
        public int getInsertPositionOffset() {
            return 0;
        }

        @Override
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        public int getCommittedTextLength() {
            return 0;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }
    }

    private static enum TerminalCursorState {
        SHOWING,
        HIDDEN,
        NO_FOCUS;

    }
}

