/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.Objects;

public interface ChronoPeriod
extends TemporalAmount {
    public static ChronoPeriod between(ChronoLocalDate chronoLocalDate, ChronoLocalDate chronoLocalDate2) {
        Objects.requireNonNull(chronoLocalDate, "startDateInclusive");
        Objects.requireNonNull(chronoLocalDate2, "endDateExclusive");
        return chronoLocalDate.until(chronoLocalDate2);
    }

    @Override
    public long get(TemporalUnit var1);

    @Override
    public List<TemporalUnit> getUnits();

    public Chronology getChronology();

    default public boolean isZero() {
        for (TemporalUnit temporalUnit : this.getUnits()) {
            if (this.get(temporalUnit) == 0L) continue;
            return false;
        }
        return true;
    }

    default public boolean isNegative() {
        for (TemporalUnit temporalUnit : this.getUnits()) {
            if (this.get(temporalUnit) >= 0L) continue;
            return true;
        }
        return false;
    }

    public ChronoPeriod plus(TemporalAmount var1);

    public ChronoPeriod minus(TemporalAmount var1);

    public ChronoPeriod multipliedBy(int var1);

    default public ChronoPeriod negated() {
        return this.multipliedBy(-1);
    }

    public ChronoPeriod normalized();

    @Override
    public Temporal addTo(Temporal var1);

    @Override
    public Temporal subtractFrom(Temporal var1);

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();
}

