/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.AdobeMarkerSegment;
import com.sun.imageio.plugins.jpeg.COMMarkerSegment;
import com.sun.imageio.plugins.jpeg.DHTMarkerSegment;
import com.sun.imageio.plugins.jpeg.DQTMarkerSegment;
import com.sun.imageio.plugins.jpeg.DRIMarkerSegment;
import com.sun.imageio.plugins.jpeg.JFIFMarkerSegment;
import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.sun.imageio.plugins.jpeg.JPEGImageWriter;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import com.sun.imageio.plugins.jpeg.SOFMarkerSegment;
import com.sun.imageio.plugins.jpeg.SOSMarkerSegment;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JPEGMetadata
extends IIOMetadata
implements Cloneable {
    private static final boolean debug = false;
    private List resetSequence;
    private boolean inThumb;
    private boolean hasAlpha;
    List markerSequence;
    final boolean isStream;
    private boolean transparencyDone;

    JPEGMetadata(boolean bl, boolean bl2) {
        super(true, "javax_imageio_jpeg_image_1.0", "com.sun.imageio.plugins.jpeg.JPEGImageMetadataFormat", null, null);
        this.resetSequence = null;
        this.inThumb = false;
        this.markerSequence = new ArrayList();
        this.inThumb = bl2;
        this.isStream = bl;
        if (bl) {
            this.nativeMetadataFormatName = "javax_imageio_jpeg_stream_1.0";
            this.nativeMetadataFormatClassName = "com.sun.imageio.plugins.jpeg.JPEGStreamMetadataFormat";
        }
    }

    JPEGMetadata(boolean bl, boolean bl2, ImageInputStream imageInputStream, JPEGImageReader jPEGImageReader) throws IOException {
        this(bl, bl2);
        JPEGBuffer jPEGBuffer = new JPEGBuffer(imageInputStream);
        jPEGBuffer.loadBuf(0);
        if ((jPEGBuffer.buf[0] & 0xFF) != 255 || (jPEGBuffer.buf[1] & 0xFF) != 216 || (jPEGBuffer.buf[2] & 0xFF) != 255) {
            throw new IIOException("Image format error");
        }
        boolean bl3 = false;
        jPEGBuffer.bufAvail -= 2;
        jPEGBuffer.bufPtr = 2;
        MarkerSegment markerSegment = null;
        while (!bl3) {
            jPEGBuffer.loadBuf(1);
            jPEGBuffer.scanForFF(jPEGImageReader);
            switch (jPEGBuffer.buf[jPEGBuffer.bufPtr] & 0xFF) {
                case 0: {
                    --jPEGBuffer.bufAvail;
                    ++jPEGBuffer.bufPtr;
                    break;
                }
                case 192: 
                case 193: 
                case 194: {
                    if (bl) {
                        throw new IIOException("SOF not permitted in stream metadata");
                    }
                    markerSegment = new SOFMarkerSegment(jPEGBuffer);
                    break;
                }
                case 219: {
                    markerSegment = new DQTMarkerSegment(jPEGBuffer);
                    break;
                }
                case 196: {
                    markerSegment = new DHTMarkerSegment(jPEGBuffer);
                    break;
                }
                case 221: {
                    markerSegment = new DRIMarkerSegment(jPEGBuffer);
                    break;
                }
                case 224: {
                    JFIFMarkerSegment jFIFMarkerSegment;
                    jPEGBuffer.loadBuf(8);
                    byte[] byArray = jPEGBuffer.buf;
                    int n = jPEGBuffer.bufPtr;
                    if (byArray[n + 3] == 74 && byArray[n + 4] == 70 && byArray[n + 5] == 73 && byArray[n + 6] == 70 && byArray[n + 7] == 0) {
                        if (this.inThumb) {
                            jPEGImageReader.warningOccurred(1);
                            jFIFMarkerSegment = new JFIFMarkerSegment(jPEGBuffer);
                            break;
                        }
                        if (bl) {
                            throw new IIOException("JFIF not permitted in stream metadata");
                        }
                        if (!this.markerSequence.isEmpty()) {
                            throw new IIOException("JFIF APP0 must be first marker after SOI");
                        }
                        markerSegment = new JFIFMarkerSegment(jPEGBuffer);
                        break;
                    }
                    if (byArray[n + 3] == 74 && byArray[n + 4] == 70 && byArray[n + 5] == 88 && byArray[n + 6] == 88 && byArray[n + 7] == 0) {
                        if (bl) {
                            throw new IIOException("JFXX not permitted in stream metadata");
                        }
                        if (this.inThumb) {
                            throw new IIOException("JFXX markers not allowed in JFIF JPEG thumbnail");
                        }
                        jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
                        if (jFIFMarkerSegment == null) {
                            throw new IIOException("JFXX encountered without prior JFIF!");
                        }
                        jFIFMarkerSegment.addJFXX(jPEGBuffer, jPEGImageReader);
                        break;
                    }
                    markerSegment = new MarkerSegment(jPEGBuffer);
                    markerSegment.loadData(jPEGBuffer);
                    break;
                }
                case 226: {
                    JFIFMarkerSegment jFIFMarkerSegment;
                    jPEGBuffer.loadBuf(15);
                    if (jPEGBuffer.buf[jPEGBuffer.bufPtr + 3] == 73 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 4] == 67 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 5] == 67 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 6] == 95 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 7] == 80 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 8] == 82 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 9] == 79 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 10] == 70 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 11] == 73 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 12] == 76 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 13] == 69 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 14] == 0) {
                        if (bl) {
                            throw new IIOException("ICC profiles not permitted in stream metadata");
                        }
                        jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
                        if (jFIFMarkerSegment == null) {
                            markerSegment = new MarkerSegment(jPEGBuffer);
                            markerSegment.loadData(jPEGBuffer);
                            break;
                        }
                        jFIFMarkerSegment.addICC(jPEGBuffer);
                        break;
                    }
                    markerSegment = new MarkerSegment(jPEGBuffer);
                    markerSegment.loadData(jPEGBuffer);
                    break;
                }
                case 238: {
                    jPEGBuffer.loadBuf(8);
                    if (jPEGBuffer.buf[jPEGBuffer.bufPtr + 3] == 65 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 4] == 100 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 5] == 111 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 6] == 98 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 7] == 101) {
                        if (bl) {
                            throw new IIOException("Adobe APP14 markers not permitted in stream metadata");
                        }
                        markerSegment = new AdobeMarkerSegment(jPEGBuffer);
                        break;
                    }
                    markerSegment = new MarkerSegment(jPEGBuffer);
                    markerSegment.loadData(jPEGBuffer);
                    break;
                }
                case 254: {
                    markerSegment = new COMMarkerSegment(jPEGBuffer);
                    break;
                }
                case 218: {
                    if (bl) {
                        throw new IIOException("SOS not permitted in stream metadata");
                    }
                    markerSegment = new SOSMarkerSegment(jPEGBuffer);
                    break;
                }
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: {
                    ++jPEGBuffer.bufPtr;
                    --jPEGBuffer.bufAvail;
                    break;
                }
                case 217: {
                    bl3 = true;
                    ++jPEGBuffer.bufPtr;
                    --jPEGBuffer.bufAvail;
                    break;
                }
                default: {
                    markerSegment = new MarkerSegment(jPEGBuffer);
                    markerSegment.loadData(jPEGBuffer);
                    markerSegment.unknown = true;
                }
            }
            if (markerSegment == null) continue;
            this.markerSequence.add(markerSegment);
            markerSegment = null;
        }
        jPEGBuffer.pushBack();
        if (!this.isConsistent()) {
            throw new IIOException("Inconsistent metadata read from stream");
        }
    }

    JPEGMetadata(ImageWriteParam imageWriteParam, JPEGImageWriter jPEGImageWriter) {
        this(true, false);
        JPEGImageWriteParam jPEGImageWriteParam = null;
        if (imageWriteParam != null && imageWriteParam instanceof JPEGImageWriteParam && !(jPEGImageWriteParam = (JPEGImageWriteParam)imageWriteParam).areTablesSet()) {
            jPEGImageWriteParam = null;
        }
        if (jPEGImageWriteParam != null) {
            this.markerSequence.add(new DQTMarkerSegment(jPEGImageWriteParam.getQTables()));
            this.markerSequence.add(new DHTMarkerSegment(jPEGImageWriteParam.getDCHuffmanTables(), jPEGImageWriteParam.getACHuffmanTables()));
        } else {
            this.markerSequence.add(new DQTMarkerSegment(JPEG.getDefaultQTables()));
            this.markerSequence.add(new DHTMarkerSegment(JPEG.getDefaultHuffmanTables(true), JPEG.getDefaultHuffmanTables(false)));
        }
        if (!this.isConsistent()) {
            throw new InternalError("Default stream metadata is inconsistent");
        }
    }

    JPEGMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, JPEGImageWriter jPEGImageWriter) {
        Object object;
        Object object2;
        int n;
        byte[] byArray;
        float f;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        int n2;
        boolean bl7;
        boolean bl8;
        block39: {
            block38: {
                this(false, false);
                bl8 = true;
                bl7 = false;
                n2 = 0;
                bl6 = true;
                bl5 = false;
                bl4 = false;
                boolean bl9 = false;
                bl3 = false;
                bl2 = true;
                bl = true;
                f = 0.75f;
                byArray = new byte[]{1, 2, 3, 4};
                n = 0;
                ImageTypeSpecifier imageTypeSpecifier2 = null;
                if (imageWriteParam != null) {
                    imageTypeSpecifier2 = imageWriteParam.getDestinationType();
                    if (imageTypeSpecifier2 != null && imageTypeSpecifier != null) {
                        jPEGImageWriter.warningOccurred(0);
                        imageTypeSpecifier2 = null;
                    }
                    if (imageWriteParam.canWriteProgressive() && imageWriteParam.getProgressiveMode() == 1) {
                        bl4 = true;
                        bl9 = true;
                        bl = false;
                    }
                    if (imageWriteParam instanceof JPEGImageWriteParam) {
                        object2 = (JPEGImageWriteParam)imageWriteParam;
                        if (((JPEGImageWriteParam)object2).areTablesSet()) {
                            bl2 = false;
                            bl = false;
                            if (((JPEGImageWriteParam)object2).getDCHuffmanTables().length > 2 || ((JPEGImageWriteParam)object2).getACHuffmanTables().length > 2) {
                                bl3 = true;
                            }
                        }
                        if (!bl4 && (bl9 = ((JPEGImageWriteParam)object2).getOptimizeHuffmanTables())) {
                            bl = false;
                        }
                    }
                    if (imageWriteParam.canWriteCompressed() && imageWriteParam.getCompressionMode() == 2) {
                        f = imageWriteParam.getCompressionQuality();
                    }
                }
                object2 = null;
                if (imageTypeSpecifier2 == null) break block38;
                object = imageTypeSpecifier2.getColorModel();
                n = ((ColorModel)object).getNumComponents();
                boolean bl10 = ((ColorModel)object).getNumColorComponents() != n;
                boolean bl11 = ((ColorModel)object).hasAlpha();
                object2 = ((ColorModel)object).getColorSpace();
                int n3 = ((ColorSpace)object2).getType();
                switch (n3) {
                    case 6: {
                        bl6 = false;
                        if (bl10) {
                            bl8 = false;
                            break;
                        }
                        break block39;
                    }
                    case 13: {
                        if (object2 == JPEG.JCS.getYCC()) {
                            bl8 = false;
                            byArray[0] = 89;
                            byArray[1] = 67;
                            byArray[2] = 99;
                            if (bl11) {
                                byArray[3] = 65;
                                break;
                            }
                        }
                        break block39;
                    }
                    case 3: {
                        if (bl10) {
                            bl8 = false;
                            if (!bl11) {
                                bl7 = true;
                                n2 = 2;
                                break;
                            }
                        }
                        break block39;
                    }
                    case 5: {
                        bl8 = false;
                        bl7 = true;
                        bl6 = false;
                        byArray[0] = 82;
                        byArray[1] = 71;
                        byArray[2] = 66;
                        if (bl11) {
                            byArray[3] = 65;
                            break;
                        }
                        break block39;
                    }
                    default: {
                        bl8 = false;
                        bl6 = false;
                        break;
                    }
                }
                break block39;
            }
            if (imageTypeSpecifier != null) {
                object = imageTypeSpecifier.getColorModel();
                n = ((ColorModel)object).getNumComponents();
                boolean bl12 = ((ColorModel)object).getNumColorComponents() != n;
                boolean bl13 = ((ColorModel)object).hasAlpha();
                object2 = ((ColorModel)object).getColorSpace();
                int n4 = ((ColorSpace)object2).getType();
                switch (n4) {
                    case 6: {
                        bl6 = false;
                        if (!bl12) break;
                        bl8 = false;
                        break;
                    }
                    case 5: {
                        if (!bl13) break;
                        bl8 = false;
                        break;
                    }
                    case 13: {
                        bl8 = false;
                        bl6 = false;
                        if (!object2.equals(ColorSpace.getInstance(1002))) break;
                        bl6 = true;
                        bl7 = true;
                        byArray[0] = 89;
                        byArray[1] = 67;
                        byArray[2] = 99;
                        if (!bl13) break;
                        byArray[3] = 65;
                        break;
                    }
                    case 3: {
                        if (!bl12) break;
                        bl8 = false;
                        if (bl13) break;
                        bl7 = true;
                        n2 = 2;
                        break;
                    }
                    case 9: {
                        bl8 = false;
                        bl7 = true;
                        n2 = 2;
                        break;
                    }
                    default: {
                        bl8 = false;
                        bl6 = false;
                    }
                }
            }
        }
        if (bl8 && JPEG.isNonStandardICC(object2)) {
            bl5 = true;
        }
        if (bl8) {
            object = new JFIFMarkerSegment();
            this.markerSequence.add(object);
            if (bl5) {
                try {
                    ((JFIFMarkerSegment)object).addICC((ICC_ColorSpace)object2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (bl7) {
            this.markerSequence.add(new AdobeMarkerSegment(n2));
        }
        if (bl2) {
            this.markerSequence.add(new DQTMarkerSegment(f, bl6));
        }
        if (bl) {
            this.markerSequence.add(new DHTMarkerSegment(bl6));
        }
        this.markerSequence.add(new SOFMarkerSegment(bl4, bl3, bl6, byArray, n));
        if (!bl4) {
            this.markerSequence.add(new SOSMarkerSegment(bl6, byArray, n));
        }
        if (!this.isConsistent()) {
            throw new InternalError("Default image metadata is inconsistent");
        }
    }

    MarkerSegment findMarkerSegment(int n) {
        for (MarkerSegment markerSegment : this.markerSequence) {
            if (markerSegment.tag != n) continue;
            return markerSegment;
        }
        return null;
    }

    MarkerSegment findMarkerSegment(Class clazz, boolean bl) {
        if (bl) {
            for (MarkerSegment markerSegment : this.markerSequence) {
                if (!clazz.isInstance(markerSegment)) continue;
                return markerSegment;
            }
        } else {
            ListIterator listIterator = this.markerSequence.listIterator(this.markerSequence.size());
            while (listIterator.hasPrevious()) {
                MarkerSegment markerSegment = (MarkerSegment)listIterator.previous();
                if (!clazz.isInstance(markerSegment)) continue;
                return markerSegment;
            }
        }
        return null;
    }

    private int findMarkerSegmentPosition(Class clazz, boolean bl) {
        if (bl) {
            ListIterator listIterator = this.markerSequence.listIterator();
            int n = 0;
            while (listIterator.hasNext()) {
                MarkerSegment markerSegment = (MarkerSegment)listIterator.next();
                if (clazz.isInstance(markerSegment)) {
                    return n;
                }
                ++n;
            }
        } else {
            ListIterator listIterator = this.markerSequence.listIterator(this.markerSequence.size());
            int n = this.markerSequence.size() - 1;
            while (listIterator.hasPrevious()) {
                MarkerSegment markerSegment = (MarkerSegment)listIterator.previous();
                if (clazz.isInstance(markerSegment)) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    private int findLastUnknownMarkerSegmentPosition() {
        ListIterator listIterator = this.markerSequence.listIterator(this.markerSequence.size());
        int n = this.markerSequence.size() - 1;
        while (listIterator.hasPrevious()) {
            MarkerSegment markerSegment = (MarkerSegment)listIterator.previous();
            if (markerSegment.unknown) {
                return n;
            }
            --n;
        }
        return -1;
    }

    protected Object clone() {
        JPEGMetadata jPEGMetadata = null;
        try {
            jPEGMetadata = (JPEGMetadata)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.markerSequence != null) {
            jPEGMetadata.markerSequence = this.cloneSequence();
        }
        jPEGMetadata.resetSequence = null;
        return jPEGMetadata;
    }

    private List cloneSequence() {
        if (this.markerSequence == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.markerSequence.size());
        for (MarkerSegment markerSegment : this.markerSequence) {
            arrayList.add(markerSegment.clone());
        }
        return arrayList;
    }

    @Override
    public Node getAsTree(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null formatName!");
        }
        if (this.isStream) {
            if (string.equals("javax_imageio_jpeg_stream_1.0")) {
                return this.getNativeTree();
            }
        } else {
            if (string.equals("javax_imageio_jpeg_image_1.0")) {
                return this.getNativeTree();
            }
            if (string.equals("javax_imageio_1.0")) {
                return this.getStandardTree();
            }
        }
        throw new IllegalArgumentException("Unsupported format name: " + string);
    }

    IIOMetadataNode getNativeTree() {
        Object object;
        IIOMetadataNode iIOMetadataNode;
        IIOMetadataNode iIOMetadataNode2;
        Iterator iterator = this.markerSequence.iterator();
        if (this.isStream) {
            iIOMetadataNode = iIOMetadataNode2 = new IIOMetadataNode("javax_imageio_jpeg_stream_1.0");
        } else {
            object = new IIOMetadataNode("markerSequence");
            if (!this.inThumb) {
                iIOMetadataNode2 = new IIOMetadataNode("javax_imageio_jpeg_image_1.0");
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("JPEGvariety");
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
                JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
                if (jFIFMarkerSegment != null) {
                    iterator.next();
                    iIOMetadataNode3.appendChild(jFIFMarkerSegment.getNativeNode());
                }
                iIOMetadataNode2.appendChild((Node)object);
            } else {
                iIOMetadataNode2 = object;
            }
            iIOMetadataNode = object;
        }
        while (iterator.hasNext()) {
            object = (MarkerSegment)iterator.next();
            iIOMetadataNode.appendChild(((MarkerSegment)object).getNativeNode());
        }
        return iIOMetadataNode2;
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        int n;
        int n2;
        this.hasAlpha = false;
        SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
        if (sOFMarkerSegment == null) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        int n3 = sOFMarkerSegment.componentSpecs.length;
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        iIOMetadataNode3.setAttribute("value", Integer.toString(n3));
        if (this.findMarkerSegment(JFIFMarkerSegment.class, true) != null) {
            if (n3 == 1) {
                iIOMetadataNode2.setAttribute("name", "GRAY");
            } else {
                iIOMetadataNode2.setAttribute("name", "YCbCr");
            }
            return iIOMetadataNode;
        }
        AdobeMarkerSegment adobeMarkerSegment = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
        if (adobeMarkerSegment != null) {
            switch (adobeMarkerSegment.transform) {
                case 2: {
                    iIOMetadataNode2.setAttribute("name", "YCCK");
                    break;
                }
                case 1: {
                    iIOMetadataNode2.setAttribute("name", "YCbCr");
                    break;
                }
                case 0: {
                    if (n3 == 3) {
                        iIOMetadataNode2.setAttribute("name", "RGB");
                        break;
                    }
                    if (n3 != 4) break;
                    iIOMetadataNode2.setAttribute("name", "CMYK");
                }
            }
            return iIOMetadataNode;
        }
        if (n3 < 3) {
            iIOMetadataNode2.setAttribute("name", "GRAY");
            if (n3 == 2) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        boolean bl = true;
        for (n2 = 0; n2 < sOFMarkerSegment.componentSpecs.length; ++n2) {
            n = sOFMarkerSegment.componentSpecs[n2].componentId;
            if (n >= 1 && n < sOFMarkerSegment.componentSpecs.length) continue;
            bl = false;
        }
        if (bl) {
            iIOMetadataNode2.setAttribute("name", "YCbCr");
            if (n3 == 4) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        if (sOFMarkerSegment.componentSpecs[0].componentId == 82 && sOFMarkerSegment.componentSpecs[1].componentId == 71 && sOFMarkerSegment.componentSpecs[2].componentId == 66) {
            iIOMetadataNode2.setAttribute("name", "RGB");
            if (n3 == 4 && sOFMarkerSegment.componentSpecs[3].componentId == 65) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        if (sOFMarkerSegment.componentSpecs[0].componentId == 89 && sOFMarkerSegment.componentSpecs[1].componentId == 67 && sOFMarkerSegment.componentSpecs[2].componentId == 99) {
            iIOMetadataNode2.setAttribute("name", "PhotoYCC");
            if (n3 == 4 && sOFMarkerSegment.componentSpecs[3].componentId == 65) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        n2 = 0;
        n = sOFMarkerSegment.componentSpecs[0].HsamplingFactor;
        int n4 = sOFMarkerSegment.componentSpecs[0].VsamplingFactor;
        for (int i = 1; i < sOFMarkerSegment.componentSpecs.length; ++i) {
            if (sOFMarkerSegment.componentSpecs[i].HsamplingFactor == n && sOFMarkerSegment.componentSpecs[i].VsamplingFactor == n4) continue;
            n2 = 1;
            break;
        }
        if (n2 != 0) {
            iIOMetadataNode2.setAttribute("name", "YCbCr");
            if (n3 == 4) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        if (n3 == 3) {
            iIOMetadataNode2.setAttribute("name", "RGB");
        } else {
            iIOMetadataNode2.setAttribute("name", "CMYK");
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        iIOMetadataNode2.setAttribute("value", "JPEG");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Lossless");
        iIOMetadataNode3.setAttribute("value", "FALSE");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        int n = 0;
        for (Object object : this.markerSequence) {
            if (((MarkerSegment)object).tag != 218) continue;
            ++n;
        }
        if (n != 0) {
            Object object;
            object = new IIOMetadataNode("NumProgressiveScans");
            ((IIOMetadataNode)object).setAttribute("value", Integer.toString(n));
            iIOMetadataNode.appendChild((Node)object);
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
        if (jFIFMarkerSegment != null) {
            float f = jFIFMarkerSegment.resUnits == 0 ? (float)jFIFMarkerSegment.Xdensity / (float)jFIFMarkerSegment.Ydensity : (float)jFIFMarkerSegment.Ydensity / (float)jFIFMarkerSegment.Xdensity;
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PixelAspectRatio");
            iIOMetadataNode3.setAttribute("value", Float.toString(f));
            iIOMetadataNode.insertBefore(iIOMetadataNode3, iIOMetadataNode2);
            if (jFIFMarkerSegment.resUnits != 0) {
                float f2 = jFIFMarkerSegment.resUnits == 1 ? 25.4f : 10.0f;
                IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("HorizontalPixelSize");
                iIOMetadataNode4.setAttribute("value", Float.toString(f2 / (float)jFIFMarkerSegment.Xdensity));
                iIOMetadataNode.appendChild(iIOMetadataNode4);
                IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("VerticalPixelSize");
                iIOMetadataNode5.setAttribute("value", Float.toString(f2 / (float)jFIFMarkerSegment.Ydensity));
                iIOMetadataNode.appendChild(iIOMetadataNode5);
            }
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardTextNode() {
        IIOMetadataNode iIOMetadataNode = null;
        if (this.findMarkerSegment(254) != null) {
            iIOMetadataNode = new IIOMetadataNode("Text");
            for (MarkerSegment markerSegment : this.markerSequence) {
                if (markerSegment.tag != 254) continue;
                COMMarkerSegment cOMMarkerSegment = (COMMarkerSegment)markerSegment;
                IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
                iIOMetadataNode2.setAttribute("keyword", "comment");
                iIOMetadataNode2.setAttribute("value", cOMMarkerSegment.getComment());
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = null;
        if (this.hasAlpha) {
            iIOMetadataNode = new IIOMetadataNode("Transparency");
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Alpha");
            iIOMetadataNode2.setAttribute("value", "nonpremultiplied");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string == null) {
            throw new IllegalArgumentException("null formatName!");
        }
        if (node == null) {
            throw new IllegalArgumentException("null root!");
        }
        List list = null;
        list = this.resetSequence == null ? (this.resetSequence = this.cloneSequence()) : this.cloneSequence();
        if (this.isStream && string.equals("javax_imageio_jpeg_stream_1.0")) {
            this.mergeNativeTree(node);
        } else if (!this.isStream && string.equals("javax_imageio_jpeg_image_1.0")) {
            this.mergeNativeTree(node);
        } else if (!this.isStream && string.equals("javax_imageio_1.0")) {
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException("Unsupported format name: " + string);
        }
        if (!this.isConsistent()) {
            this.markerSequence = list;
            throw new IIOInvalidTreeException("Merged tree is invalid; original restored", node);
        }
    }

    private void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        String string = node.getNodeName();
        if (string != (this.isStream ? "javax_imageio_jpeg_stream_1.0" : "javax_imageio_jpeg_image_1.0")) {
            throw new IIOInvalidTreeException("Invalid root node name: " + string, node);
        }
        if (node.getChildNodes().getLength() != 2) {
            throw new IIOInvalidTreeException("JPEGvariety and markerSequence nodes must be present", node);
        }
        this.mergeJFIFsubtree(node.getFirstChild());
        this.mergeSequenceSubtree(node.getLastChild());
    }

    private void mergeJFIFsubtree(Node node) throws IIOInvalidTreeException {
        if (node.getChildNodes().getLength() != 0) {
            Node node2 = node.getFirstChild();
            JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
            if (jFIFMarkerSegment != null) {
                jFIFMarkerSegment.updateFromNativeNode(node2, false);
            } else {
                this.markerSequence.add(0, new JFIFMarkerSegment(node2));
            }
        }
    }

    private void mergeSequenceSubtree(Node node) throws IIOInvalidTreeException {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("dqt")) {
                this.mergeDQTNode(node2);
                continue;
            }
            if (string.equals("dht")) {
                this.mergeDHTNode(node2);
                continue;
            }
            if (string.equals("dri")) {
                this.mergeDRINode(node2);
                continue;
            }
            if (string.equals("com")) {
                this.mergeCOMNode(node2);
                continue;
            }
            if (string.equals("app14Adobe")) {
                this.mergeAdobeNode(node2);
                continue;
            }
            if (string.equals("unknown")) {
                this.mergeUnknownNode(node2);
                continue;
            }
            if (string.equals("sof")) {
                this.mergeSOFNode(node2);
                continue;
            }
            if (string.equals("sos")) {
                this.mergeSOSNode(node2);
                continue;
            }
            throw new IIOInvalidTreeException("Invalid node: " + string, node2);
        }
    }

    private void mergeDQTNode(Node node) throws IIOInvalidTreeException {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object2 : this.markerSequence) {
            if (!(object2 instanceof DQTMarkerSegment)) continue;
            arrayList.add(object2);
        }
        if (!arrayList.isEmpty()) {
            object2 = node.getChildNodes();
            for (int i = 0; i < object2.getLength(); ++i) {
                Node node2 = object2.item(i);
                int n = MarkerSegment.getAttributeValue(node2, null, "qtableId", 0, 3, true);
                DQTMarkerSegment dQTMarkerSegment = null;
                int n2 = -1;
                for (int j = 0; j < arrayList.size(); ++j) {
                    DQTMarkerSegment dQTMarkerSegment2 = (DQTMarkerSegment)arrayList.get(j);
                    for (int k = 0; k < dQTMarkerSegment2.tables.size(); ++k) {
                        DQTMarkerSegment.Qtable qtable = (DQTMarkerSegment.Qtable)dQTMarkerSegment2.tables.get(k);
                        if (n != qtable.tableID) continue;
                        dQTMarkerSegment = dQTMarkerSegment2;
                        n2 = k;
                        break;
                    }
                    if (dQTMarkerSegment != null) break;
                }
                if (dQTMarkerSegment != null) {
                    dQTMarkerSegment.tables.set(n2, dQTMarkerSegment.getQtableFromNode(node2));
                    continue;
                }
                dQTMarkerSegment = (DQTMarkerSegment)arrayList.get(arrayList.size() - 1);
                dQTMarkerSegment.tables.add(dQTMarkerSegment.getQtableFromNode(node2));
            }
        } else {
            object2 = new DQTMarkerSegment(node);
            int n = this.findMarkerSegmentPosition(DHTMarkerSegment.class, true);
            int n3 = this.findMarkerSegmentPosition(SOFMarkerSegment.class, true);
            int n4 = this.findMarkerSegmentPosition(SOSMarkerSegment.class, true);
            if (n != -1) {
                this.markerSequence.add(n, object2);
            } else if (n3 != -1) {
                this.markerSequence.add(n3, object2);
            } else if (n4 != -1) {
                this.markerSequence.add(n4, object2);
            } else {
                this.markerSequence.add(object2);
            }
        }
    }

    private void mergeDHTNode(Node node) throws IIOInvalidTreeException {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object2 : this.markerSequence) {
            if (!(object2 instanceof DHTMarkerSegment)) continue;
            arrayList.add(object2);
        }
        if (!arrayList.isEmpty()) {
            object2 = node.getChildNodes();
            for (int i = 0; i < object2.getLength(); ++i) {
                Node node2 = object2.item(i);
                NamedNodeMap namedNodeMap = node2.getAttributes();
                int n = MarkerSegment.getAttributeValue(node2, namedNodeMap, "htableId", 0, 3, true);
                int n2 = MarkerSegment.getAttributeValue(node2, namedNodeMap, "class", 0, 1, true);
                DHTMarkerSegment dHTMarkerSegment = null;
                int n3 = -1;
                for (int j = 0; j < arrayList.size(); ++j) {
                    DHTMarkerSegment dHTMarkerSegment2 = (DHTMarkerSegment)arrayList.get(j);
                    for (int k = 0; k < dHTMarkerSegment2.tables.size(); ++k) {
                        DHTMarkerSegment.Htable htable = (DHTMarkerSegment.Htable)dHTMarkerSegment2.tables.get(k);
                        if (n != htable.tableID || n2 != htable.tableClass) continue;
                        dHTMarkerSegment = dHTMarkerSegment2;
                        n3 = k;
                        break;
                    }
                    if (dHTMarkerSegment != null) break;
                }
                if (dHTMarkerSegment != null) {
                    dHTMarkerSegment.tables.set(n3, dHTMarkerSegment.getHtableFromNode(node2));
                    continue;
                }
                dHTMarkerSegment = (DHTMarkerSegment)arrayList.get(arrayList.size() - 1);
                dHTMarkerSegment.tables.add(dHTMarkerSegment.getHtableFromNode(node2));
            }
        } else {
            object2 = new DHTMarkerSegment(node);
            int n = this.findMarkerSegmentPosition(DQTMarkerSegment.class, false);
            int n4 = this.findMarkerSegmentPosition(SOFMarkerSegment.class, true);
            int n5 = this.findMarkerSegmentPosition(SOSMarkerSegment.class, true);
            if (n != -1) {
                this.markerSequence.add(n + 1, object2);
            } else if (n4 != -1) {
                this.markerSequence.add(n4, object2);
            } else if (n5 != -1) {
                this.markerSequence.add(n5, object2);
            } else {
                this.markerSequence.add(object2);
            }
        }
    }

    private void mergeDRINode(Node node) throws IIOInvalidTreeException {
        DRIMarkerSegment dRIMarkerSegment = (DRIMarkerSegment)this.findMarkerSegment(DRIMarkerSegment.class, true);
        if (dRIMarkerSegment != null) {
            dRIMarkerSegment.updateFromNativeNode(node, false);
        } else {
            DRIMarkerSegment dRIMarkerSegment2 = new DRIMarkerSegment(node);
            int n = this.findMarkerSegmentPosition(SOFMarkerSegment.class, true);
            int n2 = this.findMarkerSegmentPosition(SOSMarkerSegment.class, true);
            if (n != -1) {
                this.markerSequence.add(n, dRIMarkerSegment2);
            } else if (n2 != -1) {
                this.markerSequence.add(n2, dRIMarkerSegment2);
            } else {
                this.markerSequence.add(dRIMarkerSegment2);
            }
        }
    }

    private void mergeCOMNode(Node node) throws IIOInvalidTreeException {
        COMMarkerSegment cOMMarkerSegment = new COMMarkerSegment(node);
        this.insertCOMMarkerSegment(cOMMarkerSegment);
    }

    private void insertCOMMarkerSegment(COMMarkerSegment cOMMarkerSegment) {
        int n = this.findMarkerSegmentPosition(COMMarkerSegment.class, false);
        boolean bl = this.findMarkerSegment(JFIFMarkerSegment.class, true) != null;
        int n2 = this.findMarkerSegmentPosition(AdobeMarkerSegment.class, true);
        if (n != -1) {
            this.markerSequence.add(n + 1, cOMMarkerSegment);
        } else if (bl) {
            this.markerSequence.add(1, cOMMarkerSegment);
        } else if (n2 != -1) {
            this.markerSequence.add(n2 + 1, cOMMarkerSegment);
        } else {
            this.markerSequence.add(0, cOMMarkerSegment);
        }
    }

    private void mergeAdobeNode(Node node) throws IIOInvalidTreeException {
        AdobeMarkerSegment adobeMarkerSegment = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
        if (adobeMarkerSegment != null) {
            adobeMarkerSegment.updateFromNativeNode(node, false);
        } else {
            AdobeMarkerSegment adobeMarkerSegment2 = new AdobeMarkerSegment(node);
            this.insertAdobeMarkerSegment(adobeMarkerSegment2);
        }
    }

    private void insertAdobeMarkerSegment(AdobeMarkerSegment adobeMarkerSegment) {
        boolean bl = this.findMarkerSegment(JFIFMarkerSegment.class, true) != null;
        int n = this.findLastUnknownMarkerSegmentPosition();
        if (bl) {
            this.markerSequence.add(1, adobeMarkerSegment);
        } else if (n != -1) {
            this.markerSequence.add(n + 1, adobeMarkerSegment);
        } else {
            this.markerSequence.add(0, adobeMarkerSegment);
        }
    }

    private void mergeUnknownNode(Node node) throws IIOInvalidTreeException {
        MarkerSegment markerSegment = new MarkerSegment(node);
        int n = this.findLastUnknownMarkerSegmentPosition();
        boolean bl = this.findMarkerSegment(JFIFMarkerSegment.class, true) != null;
        int n2 = this.findMarkerSegmentPosition(AdobeMarkerSegment.class, true);
        if (n != -1) {
            this.markerSequence.add(n + 1, markerSegment);
        } else if (bl) {
            this.markerSequence.add(1, markerSegment);
        }
        if (n2 != -1) {
            this.markerSequence.add(n2, markerSegment);
        } else {
            this.markerSequence.add(0, markerSegment);
        }
    }

    private void mergeSOFNode(Node node) throws IIOInvalidTreeException {
        SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
        if (sOFMarkerSegment != null) {
            sOFMarkerSegment.updateFromNativeNode(node, false);
        } else {
            SOFMarkerSegment sOFMarkerSegment2 = new SOFMarkerSegment(node);
            int n = this.findMarkerSegmentPosition(SOSMarkerSegment.class, true);
            if (n != -1) {
                this.markerSequence.add(n, sOFMarkerSegment2);
            } else {
                this.markerSequence.add(sOFMarkerSegment2);
            }
        }
    }

    private void mergeSOSNode(Node node) throws IIOInvalidTreeException {
        SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, true);
        SOSMarkerSegment sOSMarkerSegment2 = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, false);
        if (sOSMarkerSegment != null) {
            if (sOSMarkerSegment != sOSMarkerSegment2) {
                throw new IIOInvalidTreeException("Can't merge SOS node into a tree with > 1 SOS node", node);
            }
            sOSMarkerSegment.updateFromNativeNode(node, false);
        } else {
            this.markerSequence.add(new SOSMarkerSegment(node));
        }
    }

    private void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        this.transparencyDone = false;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("Chroma")) {
                this.mergeStandardChromaNode(node2, nodeList);
                continue;
            }
            if (string.equals("Compression")) {
                this.mergeStandardCompressionNode(node2);
                continue;
            }
            if (string.equals("Data")) {
                this.mergeStandardDataNode(node2);
                continue;
            }
            if (string.equals("Dimension")) {
                this.mergeStandardDimensionNode(node2);
                continue;
            }
            if (string.equals("Document")) {
                this.mergeStandardDocumentNode(node2);
                continue;
            }
            if (string.equals("Text")) {
                this.mergeStandardTextNode(node2);
                continue;
            }
            if (string.equals("Transparency")) {
                this.mergeStandardTransparencyNode(node2);
                continue;
            }
            throw new IIOInvalidTreeException("Invalid node: " + string, node2);
        }
    }

    private void mergeStandardChromaNode(Node node, NodeList nodeList) throws IIOInvalidTreeException {
        Object object222;
        Object object3;
        if (this.transparencyDone) {
            throw new IIOInvalidTreeException("Transparency node must follow Chroma node", node);
        }
        Node node2 = node.getFirstChild();
        if (node2 == null || !node2.getNodeName().equals("ColorSpaceType")) {
            return;
        }
        String string = node2.getAttributes().getNamedItem("name").getNodeValue();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        boolean bl3 = false;
        byte[] byArray = new byte[]{1, 2, 3, 4};
        if (string.equals("GRAY")) {
            n = 1;
            bl = true;
        } else if (string.equals("YCbCr")) {
            n = 3;
            bl = true;
            bl3 = true;
        } else if (string.equals("PhotoYCC")) {
            n = 3;
            bl2 = true;
            n2 = 1;
            byArray[0] = 89;
            byArray[1] = 67;
            byArray[2] = 99;
        } else if (string.equals("RGB")) {
            n = 3;
            bl2 = true;
            n2 = 0;
            byArray[0] = 82;
            byArray[1] = 71;
            byArray[2] = 66;
        } else if (string.equals("XYZ") || string.equals("Lab") || string.equals("Luv") || string.equals("YxY") || string.equals("HSV") || string.equals("HLS") || string.equals("CMY") || string.equals("3CLR")) {
            n = 3;
        } else if (string.equals("YCCK")) {
            n = 4;
            bl2 = true;
            n2 = 2;
            bl3 = true;
        } else if (string.equals("CMYK")) {
            n = 4;
            bl2 = true;
            n2 = 0;
        } else if (string.equals("4CLR")) {
            n = 4;
        } else {
            return;
        }
        boolean bl4 = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object3 = nodeList.item(i);
            if (!object3.getNodeName().equals("Transparency")) continue;
            bl4 = this.wantAlpha((Node)object3);
            break;
        }
        if (bl4) {
            ++n;
            bl = false;
            if (byArray[0] == 82) {
                byArray[3] = 65;
                bl2 = false;
            }
        }
        JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
        object3 = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
        SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
        SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, true);
        if (sOFMarkerSegment != null && sOFMarkerSegment.tag == 194 && sOFMarkerSegment.componentSpecs.length != n && sOSMarkerSegment != null) {
            return;
        }
        if (!bl && jFIFMarkerSegment != null) {
            this.markerSequence.remove(jFIFMarkerSegment);
        }
        if (bl && !this.isStream) {
            this.markerSequence.add(0, new JFIFMarkerSegment());
        }
        if (bl2) {
            if (object3 == null && !this.isStream) {
                object3 = new AdobeMarkerSegment(n2);
                this.insertAdobeMarkerSegment((AdobeMarkerSegment)object3);
            } else {
                ((AdobeMarkerSegment)object3).transform = n2;
            }
        } else if (object3 != null) {
            this.markerSequence.remove(object3);
        }
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int[] nArray = new int[]{0, 1, 1, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        int[] nArray3 = bl3 ? nArray : nArray2;
        SOFMarkerSegment.ComponentSpec[] componentSpecArray = null;
        if (sOFMarkerSegment != null) {
            int n3;
            componentSpecArray = sOFMarkerSegment.componentSpecs;
            bl7 = sOFMarkerSegment.tag == 194;
            this.markerSequence.set(this.markerSequence.indexOf(sOFMarkerSegment), new SOFMarkerSegment(bl7, false, bl3, byArray, n));
            for (n3 = 0; n3 < componentSpecArray.length; ++n3) {
                if (componentSpecArray[n3].QtableSelector == nArray3[n3]) continue;
                bl5 = true;
            }
            if (bl7) {
                n3 = 0;
                for (int i = 0; i < componentSpecArray.length; ++i) {
                    if (byArray[i] == componentSpecArray[i].componentId) continue;
                    n3 = 1;
                }
                if (n3 != 0) {
                    for (Object object222 : this.markerSequence) {
                        if (!(object222 instanceof SOSMarkerSegment)) continue;
                        SOSMarkerSegment object4 = (SOSMarkerSegment)object222;
                        for (int i = 0; i < object4.componentSpecs.length; ++i) {
                            int n4 = object4.componentSpecs[i].componentSelector;
                            for (int j = 0; j < componentSpecArray.length; ++j) {
                                if (componentSpecArray[j].componentId != n4) continue;
                                object4.componentSpecs[i].componentSelector = byArray[j];
                            }
                        }
                    }
                }
            } else if (sOSMarkerSegment != null) {
                for (n3 = 0; n3 < sOSMarkerSegment.componentSpecs.length; ++n3) {
                    if (sOSMarkerSegment.componentSpecs[n3].dcHuffTable == nArray3[n3] && sOSMarkerSegment.componentSpecs[n3].acHuffTable == nArray3[n3]) continue;
                    bl6 = true;
                }
                this.markerSequence.set(this.markerSequence.indexOf(sOSMarkerSegment), new SOSMarkerSegment(bl3, byArray, n));
            }
        } else if (this.isStream) {
            bl5 = true;
            bl6 = true;
        }
        if (bl5) {
            ArrayList<MarkerSegment> arrayList = new ArrayList<MarkerSegment>();
            for (Object object222 : this.markerSequence) {
                if (!(object222 instanceof DQTMarkerSegment)) continue;
                arrayList.add((MarkerSegment)object222);
            }
            if (!arrayList.isEmpty() && bl3) {
                boolean bl8 = false;
                for (DQTMarkerSegment dQTMarkerSegment : arrayList) {
                    for (DQTMarkerSegment.Qtable qtable : dQTMarkerSegment.tables) {
                        if (qtable.tableID != 1) continue;
                        bl8 = true;
                    }
                }
                if (!bl8) {
                    object222 = null;
                    for (DQTMarkerSegment dQTMarkerSegment : arrayList) {
                        for (DQTMarkerSegment.Qtable qtable : dQTMarkerSegment.tables) {
                            if (qtable.tableID != 0) continue;
                            object222 = qtable;
                        }
                    }
                    DQTMarkerSegment dQTMarkerSegment = (DQTMarkerSegment)arrayList.get(arrayList.size() - 1);
                    dQTMarkerSegment.tables.add(dQTMarkerSegment.getChromaForLuma((DQTMarkerSegment.Qtable)object222));
                }
            }
        }
        if (bl6) {
            ArrayList arrayList = new ArrayList();
            for (Object object222 : this.markerSequence) {
                if (!(object222 instanceof DHTMarkerSegment)) continue;
                arrayList.add(object222);
            }
            if (!arrayList.isEmpty() && bl3) {
                boolean bl9 = false;
                for (DHTMarkerSegment dHTMarkerSegment : arrayList) {
                    for (DHTMarkerSegment.Htable htable : dHTMarkerSegment.tables) {
                        if (htable.tableID != 1) continue;
                        bl9 = true;
                    }
                }
                if (!bl9) {
                    object222 = (DHTMarkerSegment)arrayList.get(arrayList.size() - 1);
                    ((DHTMarkerSegment)object222).addHtable(JPEGHuffmanTable.StdDCLuminance, true, 1);
                    ((DHTMarkerSegment)object222).addHtable(JPEGHuffmanTable.StdACLuminance, true, 1);
                }
            }
        }
    }

    private boolean wantAlpha(Node node) {
        String string;
        boolean bl = false;
        Node node2 = node.getFirstChild();
        if (node2.getNodeName().equals("Alpha") && node2.hasAttributes() && !(string = node2.getAttributes().getNamedItem("value").getNodeValue()).equals("none")) {
            bl = true;
        }
        this.transparencyDone = true;
        return bl;
    }

    private void mergeStandardCompressionNode(Node node) throws IIOInvalidTreeException {
    }

    private void mergeStandardDataNode(Node node) throws IIOInvalidTreeException {
    }

    private void mergeStandardDimensionNode(Node node) throws IIOInvalidTreeException {
        Object object;
        JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
        if (jFIFMarkerSegment == null) {
            int n;
            boolean bl = false;
            SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
            if (sOFMarkerSegment != null && ((n = sOFMarkerSegment.componentSpecs.length) == 1 || n == 3)) {
                bl = true;
                for (int i = 0; i < sOFMarkerSegment.componentSpecs.length; ++i) {
                    if (sOFMarkerSegment.componentSpecs[i].componentId == i + 1) continue;
                    bl = false;
                }
                object = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
                if (object != null && ((AdobeMarkerSegment)object).transform != (n == 1 ? 0 : 1)) {
                    bl = false;
                }
            }
            if (bl) {
                jFIFMarkerSegment = new JFIFMarkerSegment();
                this.markerSequence.add(0, jFIFMarkerSegment);
            }
        }
        if (jFIFMarkerSegment != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                float f;
                String string;
                Node node2 = nodeList.item(i);
                object = node2.getAttributes();
                String string2 = node2.getNodeName();
                if (string2.equals("PixelAspectRatio")) {
                    string = object.getNamedItem("value").getNodeValue();
                    f = Float.parseFloat(string);
                    Point point = JPEGMetadata.findIntegerRatio(f);
                    jFIFMarkerSegment.resUnits = 0;
                    jFIFMarkerSegment.Xdensity = point.x;
                    jFIFMarkerSegment.Xdensity = point.y;
                    continue;
                }
                if (string2.equals("HorizontalPixelSize")) {
                    string = object.getNamedItem("value").getNodeValue();
                    f = Float.parseFloat(string);
                    int n = (int)Math.round(1.0 / ((double)f * 10.0));
                    jFIFMarkerSegment.resUnits = 2;
                    jFIFMarkerSegment.Xdensity = n;
                    continue;
                }
                if (!string2.equals("VerticalPixelSize")) continue;
                string = object.getNamedItem("value").getNodeValue();
                f = Float.parseFloat(string);
                int n = (int)Math.round(1.0 / ((double)f * 10.0));
                jFIFMarkerSegment.resUnits = 2;
                jFIFMarkerSegment.Ydensity = n;
            }
        }
    }

    private static Point findIntegerRatio(float f) {
        float f2 = 0.005f;
        if ((f = Math.abs(f)) <= f2) {
            return new Point(1, 255);
        }
        if (f >= 255.0f) {
            return new Point(255, 1);
        }
        boolean bl = false;
        if ((double)f < 1.0) {
            f = 1.0f / f;
            bl = true;
        }
        int n = 1;
        int n2 = Math.round(f);
        float f3 = n2;
        float f4 = Math.abs(f - f3);
        while (f4 > f2) {
            n2 = Math.round((float)(++n) * f);
            f3 = (float)n2 / (float)n;
            f4 = Math.abs(f - f3);
        }
        return bl ? new Point(n, n2) : new Point(n2, n);
    }

    private void mergeStandardDocumentNode(Node node) throws IIOInvalidTreeException {
    }

    private void mergeStandardTextNode(Node node) throws IIOInvalidTreeException {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            NamedNodeMap namedNodeMap = node2.getAttributes();
            Node node3 = namedNodeMap.getNamedItem("compression");
            boolean bl = true;
            if (node3 != null && !(string = node3.getNodeValue()).equals("none")) {
                bl = false;
            }
            if (!bl) continue;
            string = namedNodeMap.getNamedItem("value").getNodeValue();
            COMMarkerSegment cOMMarkerSegment = new COMMarkerSegment(string);
            this.insertCOMMarkerSegment(cOMMarkerSegment);
        }
    }

    private void mergeStandardTransparencyNode(Node node) throws IIOInvalidTreeException {
        if (!this.transparencyDone && !this.isStream) {
            boolean bl = this.wantAlpha(node);
            JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
            AdobeMarkerSegment adobeMarkerSegment = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
            SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
            SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, true);
            if (sOFMarkerSegment != null && sOFMarkerSegment.tag == 194) {
                return;
            }
            if (sOFMarkerSegment != null) {
                boolean bl2;
                int n = sOFMarkerSegment.componentSpecs.length;
                boolean bl3 = bl2 = n == 2 || n == 4;
                if (bl2 != bl) {
                    if (bl) {
                        int n2;
                        ++n;
                        if (jFIFMarkerSegment != null) {
                            this.markerSequence.remove(jFIFMarkerSegment);
                        }
                        if (adobeMarkerSegment != null) {
                            adobeMarkerSegment.transform = 0;
                        }
                        SOFMarkerSegment.ComponentSpec[] componentSpecArray = new SOFMarkerSegment.ComponentSpec[n];
                        for (n2 = 0; n2 < sOFMarkerSegment.componentSpecs.length; ++n2) {
                            componentSpecArray[n2] = sOFMarkerSegment.componentSpecs[n2];
                        }
                        n2 = (byte)sOFMarkerSegment.componentSpecs[0].componentId;
                        byte by = (byte)(n2 > 1 ? 65 : 4);
                        componentSpecArray[n - 1] = sOFMarkerSegment.getComponentSpec(by, sOFMarkerSegment.componentSpecs[0].HsamplingFactor, sOFMarkerSegment.componentSpecs[0].QtableSelector);
                        sOFMarkerSegment.componentSpecs = componentSpecArray;
                        SOSMarkerSegment.ScanComponentSpec[] scanComponentSpecArray = new SOSMarkerSegment.ScanComponentSpec[n];
                        for (int i = 0; i < sOSMarkerSegment.componentSpecs.length; ++i) {
                            scanComponentSpecArray[i] = sOSMarkerSegment.componentSpecs[i];
                        }
                        scanComponentSpecArray[n - 1] = sOSMarkerSegment.getScanComponentSpec(by, 0);
                        sOSMarkerSegment.componentSpecs = scanComponentSpecArray;
                    } else {
                        SOFMarkerSegment.ComponentSpec[] componentSpecArray = new SOFMarkerSegment.ComponentSpec[--n];
                        for (int i = 0; i < n; ++i) {
                            componentSpecArray[i] = sOFMarkerSegment.componentSpecs[i];
                        }
                        sOFMarkerSegment.componentSpecs = componentSpecArray;
                        SOSMarkerSegment.ScanComponentSpec[] scanComponentSpecArray = new SOSMarkerSegment.ScanComponentSpec[n];
                        for (int i = 0; i < n; ++i) {
                            scanComponentSpecArray[i] = sOSMarkerSegment.componentSpecs[i];
                        }
                        sOSMarkerSegment.componentSpecs = scanComponentSpecArray;
                    }
                }
            }
        }
    }

    @Override
    public void setFromTree(String string, Node node) throws IIOInvalidTreeException {
        if (string == null) {
            throw new IllegalArgumentException("null formatName!");
        }
        if (node == null) {
            throw new IllegalArgumentException("null root!");
        }
        if (this.isStream && string.equals("javax_imageio_jpeg_stream_1.0")) {
            this.setFromNativeTree(node);
        } else if (!this.isStream && string.equals("javax_imageio_jpeg_image_1.0")) {
            this.setFromNativeTree(node);
        } else if (!this.isStream && string.equals("javax_imageio_1.0")) {
            super.setFromTree(string, node);
        } else {
            throw new IllegalArgumentException("Unsupported format name: " + string);
        }
    }

    private void setFromNativeTree(Node node) throws IIOInvalidTreeException {
        Node node2;
        if (this.resetSequence == null) {
            this.resetSequence = this.markerSequence;
        }
        this.markerSequence = new ArrayList();
        String string = node.getNodeName();
        if (string != (this.isStream ? "javax_imageio_jpeg_stream_1.0" : "javax_imageio_jpeg_image_1.0")) {
            throw new IIOInvalidTreeException("Invalid root node name: " + string, node);
        }
        if (!this.isStream) {
            if (node.getChildNodes().getLength() != 2) {
                throw new IIOInvalidTreeException("JPEGvariety and markerSequence nodes must be present", node);
            }
            node2 = node.getFirstChild();
            if (node2.getChildNodes().getLength() != 0) {
                this.markerSequence.add(new JFIFMarkerSegment(node2.getFirstChild()));
            }
        }
        node2 = this.isStream ? node : node.getLastChild();
        this.setFromMarkerSequenceNode(node2);
    }

    void setFromMarkerSequenceNode(Node node) throws IIOInvalidTreeException {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("dqt")) {
                this.markerSequence.add(new DQTMarkerSegment(node2));
                continue;
            }
            if (string.equals("dht")) {
                this.markerSequence.add(new DHTMarkerSegment(node2));
                continue;
            }
            if (string.equals("dri")) {
                this.markerSequence.add(new DRIMarkerSegment(node2));
                continue;
            }
            if (string.equals("com")) {
                this.markerSequence.add(new COMMarkerSegment(node2));
                continue;
            }
            if (string.equals("app14Adobe")) {
                this.markerSequence.add(new AdobeMarkerSegment(node2));
                continue;
            }
            if (string.equals("unknown")) {
                this.markerSequence.add(new MarkerSegment(node2));
                continue;
            }
            if (string.equals("sof")) {
                this.markerSequence.add(new SOFMarkerSegment(node2));
                continue;
            }
            if (string.equals("sos")) {
                this.markerSequence.add(new SOSMarkerSegment(node2));
                continue;
            }
            throw new IIOInvalidTreeException("Invalid " + (this.isStream ? "stream " : "image ") + "child: " + string, node2);
        }
    }

    private boolean isConsistent() {
        SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
        JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
        AdobeMarkerSegment adobeMarkerSegment = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
        boolean bl = true;
        if (!this.isStream) {
            if (sOFMarkerSegment != null) {
                int n = sOFMarkerSegment.componentSpecs.length;
                int n2 = this.countScanBands();
                if (n2 != 0 && n2 != n) {
                    bl = false;
                }
                if (jFIFMarkerSegment != null) {
                    if (n != 1 && n != 3) {
                        bl = false;
                    }
                    for (int i = 0; i < n; ++i) {
                        if (sOFMarkerSegment.componentSpecs[i].componentId == i + 1) continue;
                        bl = false;
                    }
                    if (adobeMarkerSegment != null && (n == 1 && adobeMarkerSegment.transform != 0 || n == 3 && adobeMarkerSegment.transform != 1)) {
                        bl = false;
                    }
                }
            } else {
                SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, true);
                if (jFIFMarkerSegment != null || adobeMarkerSegment != null || sOFMarkerSegment != null || sOSMarkerSegment != null) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private int countScanBands() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (MarkerSegment markerSegment : this.markerSequence) {
            if (!(markerSegment instanceof SOSMarkerSegment)) continue;
            SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)markerSegment;
            SOSMarkerSegment.ScanComponentSpec[] scanComponentSpecArray = sOSMarkerSegment.componentSpecs;
            for (int i = 0; i < scanComponentSpecArray.length; ++i) {
                Integer n = new Integer(scanComponentSpecArray[i].componentSelector);
                if (arrayList.contains(n)) continue;
                arrayList.add(n);
            }
        }
        return arrayList.size();
    }

    void writeToStream(ImageOutputStream imageOutputStream, boolean bl, boolean bl2, List list, ICC_Profile iCC_Profile, boolean bl3, int n, JPEGImageWriter jPEGImageWriter) throws IOException {
        if (bl2) {
            JFIFMarkerSegment.writeDefaultJFIF(imageOutputStream, list, iCC_Profile, jPEGImageWriter);
            if (!bl3 && n != -1 && n != 0 && n != 1) {
                bl3 = true;
                jPEGImageWriter.warningOccurred(13);
            }
        }
        for (MarkerSegment markerSegment : this.markerSequence) {
            MarkerSegment markerSegment2;
            if (markerSegment instanceof JFIFMarkerSegment) {
                if (bl) continue;
                markerSegment2 = (JFIFMarkerSegment)markerSegment;
                ((JFIFMarkerSegment)markerSegment2).writeWithThumbs(imageOutputStream, list, jPEGImageWriter);
                if (iCC_Profile == null) continue;
                JFIFMarkerSegment.writeICC(iCC_Profile, imageOutputStream);
                continue;
            }
            if (markerSegment instanceof AdobeMarkerSegment) {
                if (bl3) continue;
                if (n != -1) {
                    markerSegment2 = (AdobeMarkerSegment)markerSegment.clone();
                    ((AdobeMarkerSegment)markerSegment2).transform = n;
                    ((AdobeMarkerSegment)markerSegment2).write(imageOutputStream);
                    continue;
                }
                if (bl2) {
                    markerSegment2 = (AdobeMarkerSegment)markerSegment;
                    if (((AdobeMarkerSegment)markerSegment2).transform == 0 || ((AdobeMarkerSegment)markerSegment2).transform == 1) {
                        ((AdobeMarkerSegment)markerSegment2).write(imageOutputStream);
                        continue;
                    }
                    jPEGImageWriter.warningOccurred(13);
                    continue;
                }
                markerSegment.write(imageOutputStream);
                continue;
            }
            markerSegment.write(imageOutputStream);
        }
    }

    @Override
    public void reset() {
        if (this.resetSequence != null) {
            this.markerSequence = this.resetSequence;
            this.resetSequence = null;
        }
    }

    public void print() {
        for (int i = 0; i < this.markerSequence.size(); ++i) {
            MarkerSegment markerSegment = (MarkerSegment)this.markerSequence.get(i);
            markerSegment.print();
        }
    }
}

