
#define MSAASamples 4

Texture2DMS<float4, MSAASamples> tex : register(t0);

cbuffer cb : register(b12)
{
  float4 sampleOffset;
}

struct PS_INPUT
{
  float4 Pos : SV_POSITION;
};

float4 ps_main(PS_INPUT input) : SV_TARGET
{
  uint2 pixelPos = input.Pos.xy;

  pixelPos = pixelPos + sampleOffset.xy;
  
  float4 color_sum = { 0.0f, 0.0f, 0.0f, 0.0f };
  
  [unroll]
  for (uint i = 0; i < MSAASamples; i++)
  {
    float4 color = tex.Load(pixelPos, i);
    float factor = max(color.z, color.y);
    factor = max(factor, color.x);
    factor = factor + 1.0f;
    factor = 1 / factor;
    factor = factor / MSAASamples;
    
    color_sum.xyz = color_sum.xyz + (color.xyz * factor);
    
    color_sum.w = color_sum.w + color.w;
  }
  
  float factor = max(color_sum.z, color_sum.y);
  factor = max(factor, color_sum.x);
  factor = 1.0f - factor;
  factor = 1 / factor;
  
  float4 color_avg = color_sum;
  color_avg.xyz = color_avg.xyz * factor;
  color_avg.w = color_avg.w / MSAASamples;
  
  return color_avg;

}